/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.docker.compose.core.ConnectionPorts;
import org.springframework.boot.docker.compose.core.DefaultConnectionPorts;
import org.springframework.boot.docker.compose.core.DockerCliComposePsResponse;
import org.springframework.boot.docker.compose.core.DockerCliInspectResponse;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.DockerComposeOrigin;
import org.springframework.boot.docker.compose.core.DockerEnv;
import org.springframework.boot.docker.compose.core.DockerHost;
import org.springframework.boot.docker.compose.core.ImageReference;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;

class DefaultRunningService
implements RunningService,
OriginProvider {
    private final Origin origin;
    private final String name;
    private final ImageReference image;
    private final DockerHost host;
    private final DefaultConnectionPorts ports;
    private final Map<String, String> labels;
    private final DockerEnv env;

    DefaultRunningService(DockerHost host, DockerComposeFile composeFile, DockerCliComposePsResponse composePsResponse, DockerCliInspectResponse inspectResponse) {
        this.origin = new DockerComposeOrigin(composeFile, composePsResponse.name());
        this.name = composePsResponse.name();
        this.image = ImageReference.of(composePsResponse.image() != null ? composePsResponse.image() : inspectResponse.config().image());
        this.host = host;
        this.ports = new DefaultConnectionPorts(inspectResponse);
        this.env = new DockerEnv(inspectResponse.config().env());
        this.labels = Collections.unmodifiableMap(inspectResponse.config().labels());
    }

    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ImageReference image() {
        return this.image;
    }

    @Override
    public String host() {
        return this.host.toString();
    }

    @Override
    public ConnectionPorts ports() {
        return this.ports;
    }

    @Override
    public Map<String, String> env() {
        return this.env.asMap();
    }

    @Override
    public Map<String, String> labels() {
        return this.labels;
    }

    public String toString() {
        return this.name;
    }
}

