/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.sqlserver;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.r2dbc.ConnectionFactoryOptionsBuilder;
import org.springframework.boot.docker.compose.service.connection.sqlserver.SqlServerEnvironment;

class SqlServerR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    SqlServerR2dbcDockerComposeConnectionDetailsFactory() {
        super("mssql/server", "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new SqlServerR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class SqlServerR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("mssql", 1433);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        SqlServerR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            SqlServerEnvironment environment = new SqlServerEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, "", environment.getUsername(), environment.getPassword());
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

