/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LibraryScope;

public class Library {
    private final String name;
    private final File file;
    private final LibraryScope scope;
    private final LibraryCoordinates coordinates;
    private final boolean unpackRequired;
    private final boolean local;
    private final boolean included;

    public Library(File file, LibraryScope scope) {
        this(null, file, scope, null, false, false, true);
    }

    @Deprecated
    public Library(File file, LibraryScope scope, boolean unpackRequired) {
        this(null, file, scope, unpackRequired);
    }

    @Deprecated
    public Library(String name, File file, LibraryScope scope, boolean unpackRequired) {
        this(name, file, scope, null, unpackRequired);
    }

    @Deprecated
    public Library(String name, File file, LibraryScope scope, LibraryCoordinates coordinates, boolean unpackRequired) {
        this(name, file, scope, coordinates, unpackRequired, false);
    }

    @Deprecated
    public Library(String name, File file, LibraryScope scope, LibraryCoordinates coordinates, boolean unpackRequired, boolean local) {
        this(name, file, scope, coordinates, unpackRequired, local, true);
    }

    public Library(String name, File file, LibraryScope scope, LibraryCoordinates coordinates, boolean unpackRequired, boolean local, boolean included) {
        this.name = name != null ? name : file.getName();
        this.file = file;
        this.scope = scope;
        this.coordinates = coordinates;
        this.unpackRequired = unpackRequired;
        this.local = local;
        this.included = included;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public LibraryScope getScope() {
        return this.scope;
    }

    public LibraryCoordinates getCoordinates() {
        return this.coordinates;
    }

    public boolean isUnpackRequired() {
        return this.unpackRequired;
    }

    long getLastModified() {
        return this.file.lastModified();
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isIncluded() {
        return this.included;
    }
}

