/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.springframework.boot.context.embedded.tomcat.TomcatStarter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TomcatEmbeddedContext
extends StandardContext {
    private TomcatStarter starter;
    private final boolean overrideLoadOnStart = ReflectionUtils.findMethod(StandardContext.class, (String)"loadOnStartup", (Class[])new Class[]{Container[].class}).getReturnType() == Boolean.TYPE;

    TomcatEmbeddedContext() {
    }

    public boolean loadOnStartup(Container[] children) {
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup(children);
    }

    public void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            existingLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
        }
        if (this.overrideLoadOnStart) {
            super.loadOnStartup(this.findChildren());
        }
        if (existingLoader != null) {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
        }
    }

    public void setStarter(TomcatStarter starter) {
        this.starter = starter;
    }

    public TomcatStarter getStarter() {
        return this.starter;
    }
}

