/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.springframework.util.ReflectionUtils;

class JettyEmbeddedErrorHandler
extends ErrorHandler
implements ErrorHandler.ErrorPageMapper {
    static final boolean ERROR_PAGE_FOR_METHOD_AVAILABLE = ReflectionUtils.findMethod(ErrorHandler.class, (String)"errorPageForMethod", (Class[])new Class[]{String.class}) != null;
    private final ErrorHandler delegate;

    JettyEmbeddedErrorHandler(ErrorHandler delegate) {
        this.delegate = delegate;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method;
        if (!(ERROR_PAGE_FOR_METHOD_AVAILABLE || HttpMethod.GET.is(method = request.getMethod()) || HttpMethod.POST.is(method) || HttpMethod.HEAD.is(method))) {
            request = new ErrorHttpServletRequest((HttpServletRequest)request);
        }
        this.delegate.handle(target, baseRequest, request, response);
    }

    public boolean errorPageForMethod(String method) {
        return true;
    }

    public String getErrorPage(HttpServletRequest request) {
        if (this.delegate instanceof ErrorHandler.ErrorPageMapper) {
            return ((ErrorHandler.ErrorPageMapper)this.delegate).getErrorPage(request);
        }
        return null;
    }

    private static class ErrorHttpServletRequest
    extends HttpServletRequestWrapper {
        private boolean simulateGetMethod = true;

        ErrorHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return this.simulateGetMethod ? HttpMethod.GET.toString() : super.getMethod();
        }

        public ServletContext getServletContext() {
            this.simulateGetMethod = false;
            return super.getServletContext();
        }
    }
}

