/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record GraylogExtendedLogFormatProperties(@Nullable String host, Service service) {
    static final GraylogExtendedLogFormatProperties NONE = new GraylogExtendedLogFormatProperties(null, null);

    public GraylogExtendedLogFormatProperties(@Nullable String host, @Nullable Service service) {
        this.host = host;
        this.service = service != null ? service : Service.NONE;
    }

    GraylogExtendedLogFormatProperties withDefaults(Environment environment) {
        String name = GraylogExtendedLogFormatProperties.withFallbackProperty(environment, this.host, "spring.application.name");
        Service service = this.service.withDefaults(environment);
        return new GraylogExtendedLogFormatProperties(name, service);
    }

    static @Nullable String withFallbackProperty(Environment environment, @Nullable String value, String property) {
        return !StringUtils.hasLength((String)value) ? environment.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        members.add("host", this::host).whenHasLength();
        this.service.jsonMembers(members);
    }

    public static GraylogExtendedLogFormatProperties get(Environment environment) {
        return Binder.get(environment).bind("logging.structured.gelf", GraylogExtendedLogFormatProperties.class).orElse(NONE).withDefaults(environment);
    }

    public record Service(@Nullable String version) {
        static final Service NONE = new Service(null);

        Service withDefaults(Environment environment) {
            String version = GraylogExtendedLogFormatProperties.withFallbackProperty(environment, this.version, "spring.application.version");
            return new Service(version);
        }

        void jsonMembers(JsonWriter.Members<?> members) {
            members.add("_service_version", this::version).whenHasLength();
        }
    }

    static class GraylogExtendedLogFormatPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        GraylogExtendedLogFormatPropertiesRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            BindableRuntimeHintsRegistrar.forTypes(GraylogExtendedLogFormatProperties.class).registerHints(hints, classLoader);
        }
    }
}

