/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import org.jspecify.annotations.Nullable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface SslBundleKey {
    public static final SslBundleKey NONE = SslBundleKey.of(null, null);

    public @Nullable String getPassword();

    public @Nullable String getAlias();

    default public void assertContainsAlias(@Nullable KeyStore keyStore) {
        String alias = this.getAlias();
        if (StringUtils.hasLength((String)alias) && keyStore != null) {
            try {
                Assert.state((boolean)keyStore.containsAlias(alias), () -> String.format("Keystore does not contain alias '%s'", alias));
            }
            catch (KeyStoreException ex) {
                throw new IllegalStateException(String.format("Could not determine if keystore contains alias '%s'", alias), ex);
            }
        }
    }

    public static SslBundleKey of(String password) {
        return SslBundleKey.of(password, null);
    }

    public static SslBundleKey of(final @Nullable String password, final @Nullable String alias) {
        return new SslBundleKey(){

            @Override
            public @Nullable String getPassword() {
                return password;
            }

            @Override
            public @Nullable String getAlias() {
                return alias;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator((Object)this);
                creator.append("alias", (Object)alias);
                creator.append("password", (Object)(password != null ? "******" : null));
                return creator.toString();
            }
        };
    }
}

