/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.oss;

import com.aliyun.oss.OSS;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class OssApplicationListener
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(OssApplicationListener.class);

    public void onApplicationEvent(ContextClosedEvent event) {
        Map ossClientMap = event.getApplicationContext().getBeansOfType(OSS.class);
        logger.info("{} OSSClients will be shutdown soon", (Object)ossClientMap.size());
        ossClientMap.keySet().forEach(beanName -> {
            logger.info("shutdown ossClient: {}", beanName);
            ((OSS)ossClientMap.get(beanName)).shutdown();
        });
    }
}

