/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import java.util.concurrent.Future;
import org.springframework.cloud.aws.messaging.listener.Acknowledgment;

public class QueueMessageAcknowledgment
implements Acknowledgment {
    private final AmazonSQSAsync amazonSqsAsync;
    private final String queueUrl;
    private final String receiptHandle;

    public QueueMessageAcknowledgment(AmazonSQSAsync amazonSqsAsync, String queueUrl, String receiptHandle) {
        this.amazonSqsAsync = amazonSqsAsync;
        this.queueUrl = queueUrl;
        this.receiptHandle = receiptHandle;
    }

    @Override
    public Future<?> acknowledge() {
        return this.amazonSqsAsync.deleteMessageAsync(new DeleteMessageRequest(this.queueUrl, this.receiptHandle));
    }
}

