/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryCircuitBreaker;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryConfig;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class SpringRetryCircuitBreakerFactory
extends CircuitBreakerFactory<SpringRetryConfig, SpringRetryConfigBuilder> {
    private Function<String, SpringRetryConfig> defaultConfig = id -> new SpringRetryConfigBuilder((String)id).build();
    private final Map<String, Customizer<RetryTemplate>> retryTemplateCustomizers = new HashMap<String, Customizer<RetryTemplate>>();

    protected SpringRetryConfigBuilder configBuilder(String id) {
        return new SpringRetryConfigBuilder(id);
    }

    public void configureDefault(Function<String, SpringRetryConfig> defaultConfiguration) {
        this.defaultConfig = defaultConfiguration;
    }

    public CircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A circuit breaker must have an id");
        SpringRetryConfig config = this.getConfigurations().computeIfAbsent(id, this.defaultConfig);
        return new SpringRetryCircuitBreaker(id, config, this.retryTemplateCustomizers.get(id));
    }

    public void addRetryTemplateCustomizers(Customizer<RetryTemplate> customizer, String ... ids) {
        for (String id : ids) {
            this.retryTemplateCustomizers.put(id, customizer);
        }
    }
}

