/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerationException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonMappingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;

@JacksonStdImpl
public final class StringSerializer
extends NonTypedScalarSerializerBase<String> {
    public StringSerializer() {
        super(String.class);
    }

    @Override
    public boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    @Override
    public void serialize(String string, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeString(string);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper != null) {
            jsonFormatVisitorWrapper.expectStringFormat(javaType);
        }
    }
}

