/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.util.Assert;

public class DiscoveryCompositeHealthContributor
implements CompositeHealthContributor {
    private Map<String, DiscoveryHealthIndicator> indicators;

    public DiscoveryCompositeHealthContributor(Collection<DiscoveryHealthIndicator> indicators) {
        Assert.notNull(indicators, (String)"'indicators' must not be null");
        this.indicators = indicators.stream().collect(Collectors.toMap(DiscoveryHealthIndicator::getName, Function.identity()));
    }

    public HealthContributor getContributor(String name) {
        return this.asHealthIndicator(this.indicators.get(name));
    }

    public Iterator<NamedContributor<HealthContributor>> iterator() {
        return this.indicators.values().stream().map(this::asNamedContributor).iterator();
    }

    private NamedContributor<HealthContributor> asNamedContributor(final DiscoveryHealthIndicator indicator) {
        return new NamedContributor<HealthContributor>(){

            public String getName() {
                return indicator.getName();
            }

            public HealthIndicator getContributor() {
                return DiscoveryCompositeHealthContributor.this.asHealthIndicator(indicator);
            }
        };
    }

    private HealthIndicator asHealthIndicator(DiscoveryHealthIndicator indicator) {
        return indicator != null ? indicator::health : null;
    }

    public Map<String, DiscoveryHealthIndicator> getIndicators() {
        return Collections.unmodifiableMap(this.indicators);
    }
}

