/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentProperties;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.StringUtils;

public class JdbcEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final Log logger = LogFactory.getLog(JdbcEnvironmentRepository.class);
    private final JdbcTemplate jdbc;
    private final PropertiesResultSetExtractor extractor;
    private int order;
    private String sql;
    private String sqlWithoutProfile;
    private boolean failOnError;
    private boolean configIncomplete;

    @Deprecated
    public JdbcEnvironmentRepository(JdbcTemplate jdbc, JdbcEnvironmentProperties properties) {
        this(jdbc, properties, new PropertiesResultSetExtractor());
    }

    public JdbcEnvironmentRepository(JdbcTemplate jdbc, JdbcEnvironmentProperties properties, PropertiesResultSetExtractor extractor) {
        this.jdbc = jdbc;
        this.order = properties.getOrder();
        this.sql = properties.getSql();
        this.sqlWithoutProfile = properties.getSqlWithoutProfile();
        this.failOnError = properties.isFailOnError();
        this.extractor = extractor;
        this.configIncomplete = properties.isConfigIncomplete();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        Object config = application;
        if (StringUtils.isEmpty((Object)label)) {
            label = "master";
        }
        if (!StringUtils.hasText((String)profile)) {
            profile = "default";
        }
        if (this.configIncomplete && !((String)profile).startsWith("default")) {
            profile = "default," + (String)profile;
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profiles, label, null, null);
        if (!((String)config).startsWith("application")) {
            config = "application," + (String)config;
        }
        ArrayList<String> applications = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)config))));
        ArrayList<String> envs = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(profiles)));
        Collections.reverse(applications);
        Collections.reverse(envs);
        for (String app : applications) {
            for (String env : envs) {
                this.addPropertySource(environment, app, env, label);
            }
            if (this.configIncomplete) continue;
            this.addPropertySource(environment, app, null, label);
        }
        return environment;
    }

    private void addPropertySource(Environment environment, String application, String profile, String label) {
        try {
            Object name;
            Map source;
            if (profile != null) {
                source = (Map)this.jdbc.query(this.sql, (ResultSetExtractor)this.extractor, new Object[]{application, profile, label});
                name = application + "-" + profile;
            } else {
                source = (Map)this.jdbc.query(this.sqlWithoutProfile, (ResultSetExtractor)this.extractor, new Object[]{application, label});
                name = application;
            }
            if (source != null && !source.isEmpty()) {
                environment.add(new PropertySource((String)name, source));
            }
        }
        catch (DataAccessException e) {
            if (!this.failOnError) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failed to retrieve configuration from JDBC Repository", (Throwable)e);
                }
            }
            throw e;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public static class PropertiesResultSetExtractor
    implements ResultSetExtractor<Map<String, Object>> {
        public Map<String, Object> extractData(ResultSet rs) throws SQLException, DataAccessException {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
            return map;
        }
    }
}

