/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CipherEnvironmentEncryptor
implements EnvironmentEncryptor {
    private static Log logger = LogFactory.getLog(CipherEnvironmentEncryptor.class);
    private final TextEncryptorLocator encryptor;
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();

    @Autowired
    public CipherEnvironmentEncryptor(TextEncryptorLocator encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public Environment decrypt(Environment environment) {
        return this.encryptor != null ? this.decrypt(environment, this.encryptor) : environment;
    }

    private Environment decrypt(Environment environment, TextEncryptorLocator encryptor) {
        Environment result = new Environment(environment);
        for (PropertySource source : environment.getPropertySources()) {
            LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>(source.getSource());
            for (Map.Entry entry : new LinkedHashSet(map.entrySet())) {
                String value;
                Object name;
                block5: {
                    Object key = entry.getKey();
                    name = key.toString();
                    if (entry.getValue() == null || !entry.getValue().toString().startsWith("{cipher}")) continue;
                    value = entry.getValue().toString();
                    map.remove(key);
                    try {
                        value = value.substring("{cipher}".length());
                        value = encryptor.locate(this.helper.getEncryptorKeys((String)name, StringUtils.arrayToCommaDelimitedString((Object[])environment.getProfiles()), value)).decrypt(this.helper.stripPrefix(value));
                    }
                    catch (Exception e) {
                        value = "<n/a>";
                        name = "invalid." + (String)name;
                        String message = "Cannot decrypt key: " + key + " (" + e.getClass() + ": " + e.getMessage() + ")";
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)message, (Throwable)e);
                        }
                        if (!logger.isWarnEnabled()) break block5;
                        logger.warn((Object)message);
                    }
                }
                map.put(name, value);
            }
            result.add(new PropertySource(source.getName(), map));
        }
        return result;
    }
}

