/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import java.util.List;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.vault.core.VaultTemplate;

public class SpringVaultTemplateBuilder {
    private final ConfigTokenProvider configTokenProvider;
    private final List<SpringVaultClientAuthenticationProvider> authProviders;
    private final ApplicationContext applicationContext;

    public SpringVaultTemplateBuilder(ConfigTokenProvider configTokenProvider, List<SpringVaultClientAuthenticationProvider> authProviders, ApplicationContext applicationContext) {
        this.configTokenProvider = configTokenProvider;
        this.authProviders = authProviders;
        this.applicationContext = applicationContext;
    }

    public VaultTemplate build(VaultEnvironmentProperties vaultProperties) {
        SpringVaultClientConfiguration clientConfiguration = new SpringVaultClientConfiguration(vaultProperties, this.configTokenProvider, this.authProviders);
        clientConfiguration.setApplicationContext(this.applicationContext);
        return clientConfiguration.vaultTemplate();
    }
}

