/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.consul.config")
@Validated
public class ConsulConfigProperties {
    private boolean enabled = true;
    private String prefix = "config";
    @NotEmpty
    private String defaultContext = "application";
    @NotEmpty
    private String profileSeparator = ",";
    @NotNull
    private Format format = Format.KEY_VALUE;
    @NotEmpty
    private String dataKey = "data";
    @Value(value="${consul.token:${CONSUL_TOKEN:${spring.cloud.consul.token:${SPRING_CLOUD_CONSUL_TOKEN:}}}}")
    private String aclToken;
    private Watch watch = new Watch();
    private boolean failFast = true;
    private String name;

    @PostConstruct
    public void init() {
        if (this.format == Format.FILES) {
            this.profileSeparator = "-";
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @NotEmpty
    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(@NotEmpty String defaultContext) {
        this.defaultContext = defaultContext;
    }

    @NotEmpty
    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(@NotEmpty String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    @NotNull
    public Format getFormat() {
        return this.format;
    }

    public void setFormat(@NotNull Format format) {
        this.format = format;
    }

    @NotEmpty
    public String getDataKey() {
        return this.dataKey;
    }

    public void setDataKey(@NotEmpty String dataKey) {
        this.dataKey = dataKey;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("enabled", this.enabled).append("prefix", (Object)this.prefix).append("defaultContext", (Object)this.defaultContext).append("profileSeparator", (Object)this.profileSeparator).append("format", (Object)this.format).append("dataKey", (Object)this.dataKey).append("aclToken", (Object)this.aclToken).append("watch", (Object)this.watch).append("failFast", this.failFast).append("name", (Object)this.name).toString();
    }

    public static class Watch {
        private int waitTime = 55;
        private boolean enabled = true;
        private int delay = 1000;

        public int getWaitTime() {
            return this.waitTime;
        }

        public void setWaitTime(int waitTime) {
            this.waitTime = waitTime;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("waitTime", this.waitTime).append("enabled", this.enabled).append("delay", this.delay).toString();
        }
    }

    public static enum Format {
        KEY_VALUE,
        PROPERTIES,
        YAML,
        FILES;

    }
}

