/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerListFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.discovery.ConsulServer;

public class HealthServiceServerListFilter
implements ServerListFilter<Server> {
    private static final Log log = LogFactory.getLog(HealthServiceServerListFilter.class);

    public List<Server> getFilteredListOfServers(List<Server> servers) {
        ArrayList<Server> filtered = new ArrayList<Server>();
        for (Server server : servers) {
            if (server instanceof ConsulServer) {
                ConsulServer consulServer = (ConsulServer)server;
                if (!consulServer.isPassingChecks()) continue;
                filtered.add(server);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to determine aliveness of server type " + server.getClass() + ", " + server));
            }
            filtered.add(server);
        }
        return filtered;
    }
}

