/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.restart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(value="endpoints.restart")
@ManagedResource
public class RestartEndpoint
extends AbstractEndpoint<Boolean>
implements ApplicationListener<ApplicationPreparedEvent> {
    private static Log logger = LogFactory.getLog(RestartEndpoint.class);
    private ConfigurableApplicationContext context;
    private SpringApplication application;
    private String[] args;
    private ApplicationPreparedEvent event;
    private IntegrationShutdown integrationShutdown;
    private long timeout;

    public RestartEndpoint() {
        super("restart", true, false);
    }

    @ManagedAttribute
    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setIntegrationMBeanExporter(Object exporter) {
        if (exporter != null) {
            this.integrationShutdown = new IntegrationShutdown(exporter);
        }
    }

    public void onApplicationEvent(ApplicationPreparedEvent input) {
        this.event = input;
        if (this.context == null) {
            this.context = this.event.getApplicationContext();
            this.args = this.event.getArgs();
            this.application = this.event.getSpringApplication();
        }
    }

    public Boolean invoke() {
        try {
            this.restart();
            logger.info((Object)"Restarted");
            return true;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)"Could not restart", (Throwable)e);
            } else {
                logger.info((Object)("Could not restart: " + e.getMessage()));
            }
            return false;
        }
    }

    public PauseEndpoint getPauseEndpoint() {
        return new PauseEndpoint();
    }

    public ResumeEndpoint getResumeEndpoint() {
        return new ResumeEndpoint();
    }

    @ManagedOperation
    public synchronized ConfigurableApplicationContext restart() {
        if (this.context != null) {
            if (this.integrationShutdown != null) {
                this.integrationShutdown.stop(this.timeout);
            }
            this.application.setEnvironment(this.context.getEnvironment());
            this.context.close();
            this.overrideClassLoaderForRestart();
            this.context = this.application.run(this.args);
        }
        return this.context;
    }

    @ManagedAttribute
    public boolean isRunning() {
        if (this.context != null) {
            return this.context.isRunning();
        }
        return false;
    }

    @ManagedOperation
    public synchronized void pause() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    @ManagedOperation
    public synchronized void resume() {
        if (this.context != null) {
            this.context.start();
        }
    }

    private void overrideClassLoaderForRestart() {
        ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.application.getClass().getClassLoader());
    }

    private class IntegrationShutdown {
        private IntegrationMBeanExporter exporter;

        public IntegrationShutdown(Object exporter) {
            this.exporter = (IntegrationMBeanExporter)exporter;
        }

        public void stop(long timeout) {
            this.exporter.stopActiveComponents(timeout);
        }
    }

    @ConfigurationProperties(value="endpoints.resume")
    public class ResumeEndpoint
    extends AbstractEndpoint<Boolean> {
        public ResumeEndpoint() {
            super("resume", true, true);
        }

        public Boolean invoke() {
            if (!RestartEndpoint.this.isRunning()) {
                RestartEndpoint.this.resume();
                return true;
            }
            return false;
        }
    }

    @ConfigurationProperties(value="endpoints.pause")
    public class PauseEndpoint
    extends AbstractEndpoint<Boolean> {
        public PauseEndpoint() {
            super("pause", true, true);
        }

        public Boolean invoke() {
            if (RestartEndpoint.this.isRunning()) {
                RestartEndpoint.this.pause();
                return true;
            }
            return false;
        }
    }
}

