/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class ConfigDataContextRefresher
extends ContextRefresher {
    @Deprecated
    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        super(context, scope);
    }

    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshAutoConfiguration.RefreshProperties properties) {
        super(context, scope, properties);
    }

    @Override
    protected void updateEnvironment() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Re-processing environment to add config data");
        }
        StandardEnvironment environment = this.copyEnvironment(this.getContext().getEnvironment());
        String[] activeProfiles = this.getContext().getEnvironment().getActiveProfiles();
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        ConfigDataEnvironmentPostProcessor.applyTo((ConfigurableEnvironment)environment, (ResourceLoader)resourceLoader, (ConfigurableBootstrapContext)new DefaultBootstrapContext(), (String[])activeProfiles);
        if (environment.getPropertySources().contains("refreshArgs")) {
            environment.getPropertySources().remove("refreshArgs");
        }
        MutablePropertySources target = this.getContext().getEnvironment().getPropertySources();
        String targetName = null;
        for (PropertySource source : environment.getPropertySources()) {
            String name = source.getName();
            if (target.contains(name)) {
                targetName = name;
            }
            if (this.standardSources.contains(name)) continue;
            if (target.contains(name)) {
                target.replace(name, source);
                continue;
            }
            if (targetName != null) {
                target.addAfter(targetName, source);
                targetName = name;
                continue;
            }
            target.addFirst(source);
            targetName = name;
        }
    }
}

