/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

class InputEnricher
implements Function<Object, Object> {
    protected Log logger = LogFactory.getLog(InputEnricher.class);
    private final Map<String, Map<String, String>> headerExpressions;
    private final SpelExpressionParser spelParser = new SpelExpressionParser();
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();

    InputEnricher(Map headerExpressions, @Nullable BeanResolver beanResolver) {
        Assert.notEmpty((Map)headerExpressions, (String)"'headerExpressions' must not be null or empty");
        this.headerExpressions = headerExpressions;
        this.evalContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        if (beanResolver != null) {
            this.evalContext.setBeanResolver(beanResolver);
        }
    }

    @Override
    public Object apply(Object input) {
        if (input instanceof Message) {
            MessageBuilder messageBuilder = MessageBuilder.fromMessage((Message)((Message)input));
            Map<String, String> mappings = this.headerExpressions.get("0");
            for (Map.Entry<String, String> keyValueExpressionEntry : mappings.entrySet()) {
                Expression expression = this.spelParser.parseExpression(keyValueExpressionEntry.getValue());
                try {
                    Object value = expression.getValue((EvaluationContext)this.evalContext, input, Object.class);
                    messageBuilder.setHeader(keyValueExpressionEntry.getKey(), value);
                }
                catch (Exception e) {
                    String message = "Failed while evaluating expression \"" + keyValueExpressionEntry.getValue() + "\"  on incoming message";
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn((Object)(message + ": " + input), (Throwable)e);
                        continue;
                    }
                    this.logger.warn((Object)message);
                }
            }
            input = messageBuilder.build();
        }
        return input;
    }
}

