/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class SmartCompositeMessageConverter
extends CompositeMessageConverter {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SmartCompositeMessageConverter(Collection<MessageConverter> converters) {
        super(converters);
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        for (MessageConverter converter : this.getConverters()) {
            if (!(message.getPayload() instanceof byte[]) && targetClass.isInstance(message.getPayload()) && !(message.getPayload() instanceof Collection)) {
                return message.getPayload();
            }
            try {
                Object result = converter.fromMessage(message, targetClass);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Failure during type conversion by " + converter + ". Will try the next converter."), (Throwable)e);
            }
        }
        return null;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        if (!(message.getPayload() instanceof byte[]) && targetClass.isInstance(message.getPayload()) && !(message.getPayload() instanceof Collection)) {
            return message.getPayload();
        }
        ArrayList<Object> result = null;
        if (message.getPayload() instanceof Iterable && conversionHint != null) {
            Iterable iterablePayload = (Iterable)message.getPayload();
            Type genericItemType = FunctionTypeUtils.getImmediateGenericType((Type)conversionHint, 0);
            Class<?> genericItemRawType = FunctionTypeUtils.getRawType(genericItemType);
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (Object item : iterablePayload) {
                boolean isConverted = false;
                if (item.getClass().getName().startsWith("org.springframework.kafka.support.KafkaNull")) {
                    resultList.add(null);
                    isConverted = true;
                }
                Iterator iterator = this.getConverters().iterator();
                while (iterator.hasNext() && !isConverted) {
                    MessageConverter converter = (MessageConverter)iterator.next();
                    if (converter.getClass().getName().endsWith("ApplicationJsonMessageMarshallingConverter")) continue;
                    Message m = MessageBuilder.withPayload(item).copyHeaders((Map)message.getHeaders()).build();
                    Object conversionResult = converter instanceof SmartMessageConverter & genericItemRawType != genericItemType ? ((SmartMessageConverter)converter).fromMessage(m, genericItemRawType, (Object)genericItemType) : converter.fromMessage(m, genericItemRawType);
                    if (conversionResult == null) continue;
                    resultList.add(conversionResult);
                    isConverted = true;
                }
            }
            result = resultList;
        } else {
            for (MessageConverter converter : this.getConverters()) {
                if (converter.getClass().getName().endsWith("ApplicationJsonMessageMarshallingConverter") || (result = converter instanceof SmartMessageConverter ? ((SmartMessageConverter)converter).fromMessage(message, targetClass, conversionHint) : converter.fromMessage(message, targetClass)) == null) continue;
                return result;
            }
        }
        return result;
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
        for (MessageConverter converter : this.getConverters()) {
            String[] contentTypes;
            if (headers.get((Object)"contentType") == null) {
                return null;
            }
            String value = headers.get((Object)"contentType").toString();
            for (String contentType : contentTypes = StringUtils.delimitedListToStringArray((String)value, (String)",")) {
                if (!MimeType.valueOf((String)contentType).isConcrete()) {
                    List supportedMimeTypes = ((AbstractMessageConverter)converter).getSupportedMimeTypes();
                    for (MimeType supportedMimeType : supportedMimeTypes) {
                        if (!supportedMimeType.isCompatibleWith(MimeType.valueOf((String)contentType))) continue;
                        MessageHeaderAccessor h = new MessageHeaderAccessor();
                        h.copyHeaders((Map)headers);
                        h.setHeader("contentType", (Object)supportedMimeType);
                        Message result = converter.toMessage(payload, h.getMessageHeaders());
                        if (result == null) continue;
                        return result;
                    }
                    continue;
                }
                MessageHeaderAccessor h = new MessageHeaderAccessor();
                h.copyHeaders((Map)headers);
                h.setHeader("contentType", (Object)contentType);
                Message result = converter.toMessage(payload, h.getMessageHeaders());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        for (MessageConverter converter : this.getConverters()) {
            String[] contentTypes;
            String value = headers.get((Object)"contentType").toString();
            for (String contentType : contentTypes = StringUtils.delimitedListToStringArray((String)value, (String)",")) {
                if (!MimeType.valueOf((String)contentType).isConcrete()) {
                    List supportedMimeTypes = ((AbstractMessageConverter)converter).getSupportedMimeTypes();
                    for (MimeType supportedMimeType : supportedMimeTypes) {
                        MessageHeaderAccessor h = new MessageHeaderAccessor();
                        h.copyHeaders((Map)headers);
                        h.setHeader("contentType", (Object)supportedMimeType);
                        Message result = ((SmartMessageConverter)converter).toMessage(payload, h.getMessageHeaders(), conversionHint);
                        if (result == null) continue;
                        return result;
                    }
                    continue;
                }
                MessageHeaderAccessor h = new MessageHeaderAccessor();
                h.copyHeaders((Map)headers);
                h.setHeader("contentType", (Object)contentType);
                Message result = ((SmartMessageConverter)converter).toMessage(payload, h.getMessageHeaders(), conversionHint);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

