/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import java.nio.charset.StandardCharsets;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class PrimitiveTypesFromStringMessageConverter
extends AbstractMessageConverter {
    private final ConversionService conversionService;

    public PrimitiveTypesFromStringMessageConverter(ConversionService conversionService) {
        super(new MimeType("text", "plain"));
        this.conversionService = conversionService;
    }

    protected boolean supports(Class<?> clazz) {
        return Integer.class == clazz || Long.class == clazz;
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        return this.conversionService.convert(message.getPayload(), targetClass);
    }

    @Nullable
    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        return payload.toString().getBytes(StandardCharsets.UTF_8);
    }
}

