/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WebsocketRoutingFilter
implements GlobalFilter,
Ordered {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final Log log = LogFactory.getLog(WebsocketRoutingFilter.class);
    private final WebSocketClient webSocketClient;
    private final WebSocketService webSocketService;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private volatile List<HttpHeadersFilter> headersFilters;

    public WebsocketRoutingFilter(WebSocketClient webSocketClient, WebSocketService webSocketService, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider) {
        this.webSocketClient = webSocketClient;
        this.webSocketService = webSocketService;
        this.headersFiltersProvider = headersFiltersProvider;
    }

    static String convertHttpToWs(String scheme) {
        return "http".equals(scheme = scheme.toLowerCase()) ? "ws" : ("https".equals(scheme) ? "wss" : scheme);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        WebsocketRoutingFilter.changeSchemeIfIsWebSocketUpgrade(exchange);
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"ws".equals(scheme) && !"wss".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        HttpHeaders headers = exchange.getRequest().getHeaders();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange);
        List protocols = headers.get((Object)SEC_WEBSOCKET_PROTOCOL);
        if (protocols != null) {
            protocols = headers.get((Object)SEC_WEBSOCKET_PROTOCOL).stream().flatMap(header -> Arrays.stream(StringUtils.commaDelimitedListToStringArray((String)header))).map(String::trim).collect(Collectors.toList());
        }
        return this.webSocketService.handleRequest(exchange, (WebSocketHandler)new ProxyWebSocketHandler(requestUrl, this.webSocketClient, filtered, protocols));
    }

    private List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = (List)this.headersFiltersProvider.getIfAvailable(ArrayList::new);
            this.headersFilters.add((headers, exchange) -> {
                HttpHeaders filtered = new HttpHeaders();
                headers.entrySet().stream().filter(entry -> !((String)entry.getKey()).toLowerCase().startsWith("sec-websocket")).forEach(header -> filtered.addAll((String)header.getKey(), (List)header.getValue()));
                return filtered;
            });
        }
        return this.headersFilters;
    }

    static void changeSchemeIfIsWebSocketUpgrade(ServerWebExchange exchange) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme().toLowerCase();
        String upgrade = exchange.getRequest().getHeaders().getUpgrade();
        if ("WebSocket".equalsIgnoreCase(upgrade) && ("http".equals(scheme) || "https".equals(scheme))) {
            String wsScheme = WebsocketRoutingFilter.convertHttpToWs(scheme);
            boolean encoded = ServerWebExchangeUtils.containsEncodedParts(requestUrl);
            URI wsRequestUrl = UriComponentsBuilder.fromUri((URI)requestUrl).scheme(wsScheme).build(encoded).toUri();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, wsRequestUrl);
            if (log.isTraceEnabled()) {
                log.trace((Object)("changeSchemeTo:[" + wsRequestUrl + "]"));
            }
        }
    }

    private static class ProxyWebSocketHandler
    implements WebSocketHandler {
        private final WebSocketClient client;
        private final URI url;
        private final HttpHeaders headers;
        private final List<String> subProtocols;

        ProxyWebSocketHandler(URI url, WebSocketClient client, HttpHeaders headers, List<String> protocols) {
            this.client = client;
            this.url = url;
            this.headers = headers;
            this.subProtocols = protocols != null ? protocols : Collections.emptyList();
        }

        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        public Mono<Void> handle(final WebSocketSession session) {
            return this.client.execute(this.url, this.headers, new WebSocketHandler(){

                public Mono<Void> handle(WebSocketSession proxySession) {
                    Mono proxySessionSend = proxySession.send((Publisher)session.receive().doOnNext(WebSocketMessage::retain));
                    Mono serverSessionSend = session.send((Publisher)proxySession.receive().doOnNext(WebSocketMessage::retain));
                    return Mono.zip((Mono)proxySessionSend, (Mono)serverSessionSend).then();
                }

                public List<String> getSubProtocols() {
                    return subProtocols;
                }
            });
        }
    }
}

