/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

public class HttpClientFactory
extends AbstractFactoryBean<HttpClient> {
    protected final HttpClientProperties properties;
    protected final ServerProperties serverProperties;
    protected final List<HttpClientCustomizer> customizers;

    public HttpClientFactory(HttpClientProperties properties, ServerProperties serverProperties, List<HttpClientCustomizer> customizers) {
        this.properties = properties;
        this.serverProperties = serverProperties;
        this.customizers = customizers;
    }

    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    protected HttpClient createInstance() {
        ConnectionProvider connectionProvider = this.buildConnectionProvider(this.properties);
        HttpClient httpClient = HttpClient.create((ConnectionProvider)connectionProvider).httpResponseDecoder(this::httpResponseDecoder);
        if (this.serverProperties.getHttp2().isEnabled()) {
            httpClient = httpClient.protocol(new HttpProtocol[]{HttpProtocol.HTTP11, HttpProtocol.H2});
        }
        if (this.properties.getConnectTimeout() != null) {
            httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.properties.getConnectTimeout());
        }
        httpClient = this.configureProxy(httpClient);
        httpClient = this.configureSsl(httpClient);
        if (this.properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        if (this.properties.isCompression()) {
            httpClient = httpClient.compress(true);
        }
        httpClient = this.applyCustomizers(httpClient);
        return httpClient;
    }

    private HttpClient applyCustomizers(HttpClient httpClient) {
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.sort((Comparator<HttpClientCustomizer>)AnnotationAwareOrderComparator.INSTANCE);
            for (HttpClientCustomizer customizer : this.customizers) {
                httpClient = customizer.customize(httpClient);
            }
        }
        return httpClient;
    }

    protected HttpClient configureSsl(HttpClient httpClient) {
        HttpClientProperties.Ssl ssl = this.properties.getSsl();
        if (ssl.getKeyStore() != null && ssl.getKeyStore().length() > 0 || this.getTrustedX509CertificatesForTrustManager().length > 0 || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> this.configureSslContext(ssl, (SslProvider.SslContextSpec)sslContextSpec));
        }
        return httpClient;
    }

    protected void configureSslContext(HttpClientProperties.Ssl ssl, SslProvider.SslContextSpec sslContextSpec) {
        Http2SslContextSpec clientSslContext = this.serverProperties.getHttp2().isEnabled() ? Http2SslContextSpec.forClient() : Http11SslContextSpec.forClient();
        clientSslContext.configure(sslContextBuilder -> {
            X509Certificate[] trustedX509Certificates = this.getTrustedX509CertificatesForTrustManager();
            if (trustedX509Certificates.length > 0) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, trustedX509Certificates);
            } else if (ssl.isUseInsecureTrustManager()) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, InsecureTrustManagerFactory.INSTANCE);
            }
            try {
                sslContextBuilder.keyManager(this.getKeyManagerFactory());
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        });
        sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)clientSslContext).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
    }

    protected HttpClient configureProxy(HttpClient httpClient) {
        if (StringUtils.hasText((String)this.properties.getProxy().getHost())) {
            HttpClientProperties.Proxy proxy = this.properties.getProxy();
            httpClient = (HttpClient)httpClient.proxy(proxySpec -> this.configureProxyProvider(proxy, (ProxyProvider.TypeSpec)proxySpec));
        }
        return httpClient;
    }

    protected ProxyProvider.Builder configureProxyProvider(HttpClientProperties.Proxy proxy, ProxyProvider.TypeSpec proxySpec) {
        ProxyProvider.Builder builder = proxySpec.type(proxy.getType()).host(proxy.getHost());
        PropertyMapper map = PropertyMapper.get();
        map.from(proxy::getPort).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
        map.from(proxy::getUsername).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
        map.from(proxy::getPassword).whenHasText().to(password -> builder.password(s -> password));
        map.from(proxy::getNonProxyHostsPattern).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
        return builder;
    }

    protected HttpResponseDecoderSpec httpResponseDecoder(HttpResponseDecoderSpec spec) {
        if (this.properties.getMaxHeaderSize() != null) {
            spec.maxHeaderSize((int)this.properties.getMaxHeaderSize().toBytes());
        }
        if (this.properties.getMaxInitialLineLength() != null) {
            spec.maxInitialLineLength((int)this.properties.getMaxInitialLineLength().toBytes());
        }
        return spec;
    }

    protected X509Certificate[] getTrustedX509CertificatesForTrustManager() {
        HttpClientProperties.Ssl ssl = this.properties.getSsl();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
            for (String trustedCert : ssl.getTrustedX509Certificates()) {
                try {
                    URL url = ResourceUtils.getURL((String)trustedCert);
                    Collection<? extends Certificate> certs = certificateFactory.generateCertificates(url.openStream());
                    allCerts.addAll(certs);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load certificate '" + trustedCert + "'", e);
                }
            }
            return allCerts.toArray(new X509Certificate[allCerts.size()]);
        }
        catch (CertificateException e1) {
            throw new RuntimeException("Could not load CertificateFactory X.509", e1);
        }
    }

    protected KeyManagerFactory getKeyManagerFactory() {
        HttpClientProperties.Ssl ssl = this.properties.getSsl();
        try {
            if (ssl.getKeyStore() != null && ssl.getKeyStore().length() > 0) {
                char[] keyPassword;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                char[] cArray = keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : null;
                if (keyPassword == null && ssl.getKeyStorePassword() != null) {
                    keyPassword = ssl.getKeyStorePassword().toCharArray();
                }
                keyManagerFactory.init(this.createKeyStore(), keyPassword);
                return keyManagerFactory;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected KeyStore createKeyStore() {
        HttpClientProperties.Ssl ssl = this.properties.getSsl();
        try {
            KeyStore store = ssl.getKeyStoreProvider() != null ? KeyStore.getInstance(ssl.getKeyStoreType(), ssl.getKeyStoreProvider()) : KeyStore.getInstance(ssl.getKeyStoreType());
            try {
                URL url = ResourceUtils.getURL((String)ssl.getKeyStore());
                store.load(url.openStream(), ssl.getKeyStorePassword() != null ? ssl.getKeyStorePassword().toCharArray() : null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load key store ' " + ssl.getKeyStore() + "'", e);
            }
            return store;
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            throw new RuntimeException("Could not load KeyStore for given type and provider", e);
        }
    }

    protected void setTrustManager(SslContextBuilder sslContextBuilder, X509Certificate ... trustedX509Certificates) {
        sslContextBuilder.trustManager(trustedX509Certificates);
    }

    protected void setTrustManager(SslContextBuilder sslContextBuilder, TrustManagerFactory factory) {
        sslContextBuilder.trustManager(factory);
    }

    protected ConnectionProvider buildConnectionProvider(HttpClientProperties properties) {
        ConnectionProvider connectionProvider;
        HttpClientProperties.Pool pool = properties.getPool();
        if (pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED) {
            connectionProvider = ConnectionProvider.newConnection();
        } else {
            ConnectionProvider.Builder builder = ConnectionProvider.builder((String)pool.getName());
            if (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED) {
                ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(pool.getMaxConnections().intValue())).pendingAcquireMaxCount(-1)).pendingAcquireTimeout(Duration.ofMillis(pool.getAcquireTimeout()));
            } else {
                ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(Integer.MAX_VALUE)).pendingAcquireTimeout(Duration.ofMillis(0L))).pendingAcquireMaxCount(-1);
            }
            if (pool.getMaxIdleTime() != null) {
                builder.maxIdleTime(pool.getMaxIdleTime());
            }
            if (pool.getMaxLifeTime() != null) {
                builder.maxLifeTime(pool.getMaxLifeTime());
            }
            builder.evictInBackground(pool.getEvictionInterval());
            builder.metrics(pool.isMetrics());
            connectionProvider = builder.build();
        }
        return connectionProvider;
    }
}

