/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CacheRequestBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public CacheRequestBodyGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ServerHttpRequest request = exchange.getRequest();
                URI requestUri = request.getURI();
                String scheme = requestUri.getScheme();
                if (!"http".equals(scheme) && !"https".equals(scheme)) {
                    return chain.filter(exchange);
                }
                Object cachedBody = exchange.getAttribute("cachedRequestBody");
                if (cachedBody != null) {
                    return chain.filter(exchange);
                }
                return ServerWebExchangeUtils.cacheRequestBodyAndRequest(exchange, serverHttpRequest -> {
                    ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange.mutate().request(serverHttpRequest).build(), (List)CacheRequestBodyGatewayFilterFactory.this.messageReaders);
                    return serverRequest.bodyToMono(config.getBodyClass()).doOnNext(objectValue -> exchange.getAttributes().put("cachedRequestBody", objectValue)).then(Mono.defer(() -> {
                        ServerHttpRequest cachedRequest = (ServerHttpRequest)exchange.getAttribute("cachedServerHttpRequestDecorator");
                        Assert.notNull((Object)cachedRequest, (String)"cache request shouldn't be null");
                        exchange.getAttributes().remove("cachedServerHttpRequestDecorator");
                        return chain.filter(exchange.mutate().request(cachedRequest).build());
                    }));
                });
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(CacheRequestBodyGatewayFilterFactory.this).append("Body class", config.getBodyClass()).toString();
            }
        };
    }

    public static class Config {
        private Class<?> bodyClass;

        public Class<?> getBodyClass() {
            return this.bodyClass;
        }

        public void setBodyClass(Class<?> bodyClass) {
            this.bodyClass = bodyClass;
        }
    }
}

