/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.gateway.support.StatefulConfigurable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface RateLimiter<C>
extends StatefulConfigurable<C> {
    public Mono<Response> isAllowed(String var1, String var2);

    public static class Response {
        private final boolean allowed;
        private final long tokensRemaining;
        private final Map<String, String> headers;

        public Response(boolean allowed, Map<String, String> headers) {
            this.allowed = allowed;
            this.tokensRemaining = -1L;
            Assert.notNull(headers, (String)"headers may not be null");
            this.headers = headers;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Response{");
            sb.append("allowed=").append(this.allowed);
            sb.append(", headers=").append(this.headers);
            sb.append(", tokensRemaining=").append(this.tokensRemaining);
            sb.append('}');
            return sb.toString();
        }
    }
}

