/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.HasConfig;
import org.springframework.cloud.gateway.support.Visitor;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface AsyncPredicate<T>
extends Function<T, Publisher<Boolean>>,
HasConfig {
    default public AsyncPredicate<T> and(AsyncPredicate<? super T> other) {
        return new AndAsyncPredicate<T>(this, other);
    }

    default public AsyncPredicate<T> negate() {
        return new NegateAsyncPredicate(this);
    }

    default public AsyncPredicate<T> not(AsyncPredicate<? super T> other) {
        return new NegateAsyncPredicate<T>(other);
    }

    default public AsyncPredicate<T> or(AsyncPredicate<? super T> other) {
        return new OrAsyncPredicate<T>(this, other);
    }

    default public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public static AsyncPredicate<ServerWebExchange> from(Predicate<? super ServerWebExchange> predicate) {
        return new DefaultAsyncPredicate<ServerWebExchange>(GatewayPredicate.wrapIfNeeded(predicate));
    }

    public static class OrAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final AsyncPredicate<? super T> left;
        private final AsyncPredicate<? super T> right;

        public OrAsyncPredicate(AsyncPredicate<? super T> left, AsyncPredicate<? super T> right) {
            Assert.notNull(left, (String)"Left AsyncPredicate must not be null");
            Assert.notNull(right, (String)"Right AsyncPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public Publisher<Boolean> apply(T t) {
            return Mono.from((Publisher)((Publisher)this.left.apply(t))).flatMap(result -> result != false ? Mono.just((Object)true) : Mono.from((Publisher)((Publisher)this.right.apply(t))));
        }

        @Override
        public void accept(Visitor visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    public static class AndAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final AsyncPredicate<? super T> left;
        private final AsyncPredicate<? super T> right;

        public AndAsyncPredicate(AsyncPredicate<? super T> left, AsyncPredicate<? super T> right) {
            Assert.notNull(left, (String)"Left AsyncPredicate must not be null");
            Assert.notNull(right, (String)"Right AsyncPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public Publisher<Boolean> apply(T t) {
            return Mono.from((Publisher)((Publisher)this.left.apply(t))).flatMap(result -> result == false ? Mono.just((Object)false) : Mono.from((Publisher)((Publisher)this.right.apply(t))));
        }

        @Override
        public void accept(Visitor visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    public static class NegateAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final AsyncPredicate<? super T> predicate;

        public NegateAsyncPredicate(AsyncPredicate<? super T> predicate) {
            Assert.notNull(predicate, (String)"predicate AsyncPredicate must not be null");
            this.predicate = predicate;
        }

        @Override
        public Publisher<Boolean> apply(T t) {
            return Mono.from((Publisher)((Publisher)this.predicate.apply(t))).map(b -> b == false);
        }

        public String toString() {
            return String.format("!(%s)", this.predicate);
        }
    }

    public static class DefaultAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final Predicate<T> delegate;

        public DefaultAsyncPredicate(Predicate<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Publisher<Boolean> apply(T t) {
            return Mono.just((Object)this.delegate.test(t));
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void accept(Visitor visitor) {
            if (this.delegate instanceof GatewayPredicate) {
                GatewayPredicate gatewayPredicate = (GatewayPredicate)this.delegate;
                gatewayPredicate.accept(visitor);
            }
        }
    }
}

