/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;

public final class NameUtils {
    public static final String GENERATED_NAME_PREFIX = "_genkey_";
    private static final Pattern NAME_PATTERN = Pattern.compile("([A-Z][a-z0-9]+)");

    private NameUtils() {
        throw new AssertionError((Object)"Must not instantiate utility class.");
    }

    public static String generateName(int i) {
        return GENERATED_NAME_PREFIX + i;
    }

    public static String normalizeRoutePredicateName(Class<? extends RoutePredicateFactory> clazz) {
        return NameUtils.removeGarbage(clazz.getSimpleName().replace(RoutePredicateFactory.class.getSimpleName(), ""));
    }

    public static String normalizeRoutePredicateNameAsProperty(Class<? extends RoutePredicateFactory> clazz) {
        return NameUtils.normalizeToCanonicalPropertyFormat(NameUtils.normalizeRoutePredicateName(clazz));
    }

    public static String normalizeFilterFactoryName(Class<? extends GatewayFilterFactory> clazz) {
        return NameUtils.removeGarbage(clazz.getSimpleName().replace(GatewayFilterFactory.class.getSimpleName(), ""));
    }

    public static String normalizeGlobalFilterName(Class<? extends GlobalFilter> clazz) {
        return NameUtils.removeGarbage(clazz.getSimpleName().replace(GlobalFilter.class.getSimpleName(), "")).replace("Filter", "");
    }

    public static String normalizeFilterFactoryNameAsProperty(Class<? extends GatewayFilterFactory> clazz) {
        return NameUtils.normalizeToCanonicalPropertyFormat(NameUtils.normalizeFilterFactoryName(clazz));
    }

    public static String normalizeGlobalFilterNameAsProperty(Class<? extends GlobalFilter> filterClass) {
        return NameUtils.normalizeToCanonicalPropertyFormat(NameUtils.normalizeGlobalFilterName(filterClass));
    }

    public static String normalizeToCanonicalPropertyFormat(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (stringBuffer.length() != 0) {
                matcher.appendReplacement(stringBuffer, "-" + matcher.group(1));
                continue;
            }
            matcher.appendReplacement(stringBuffer, matcher.group(1));
        }
        return stringBuffer.toString().toLowerCase();
    }

    private static String removeGarbage(String s) {
        int garbageIdx = s.indexOf("$Mockito");
        if (garbageIdx > 0) {
            return s.substring(0, garbageIdx);
        }
        return s;
    }
}

