/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

public class SetStatusCodeAfterCacheExchangeMutator
implements AfterCacheExchangeMutator {
    private static final String NO_CACHE_VALUE = "no-cache";

    @Override
    public void accept(ServerWebExchange exchange, CachedResponse cachedResponse) {
        HttpHeaders requestHeaders = exchange.getRequest().getHeaders();
        ServerHttpResponse response = exchange.getResponse();
        if (!CollectionUtils.isEmpty(cachedResponse.body()) && this.isRequestNoCache(requestHeaders)) {
            response.setStatusCode((HttpStatusCode)HttpStatus.NOT_MODIFIED);
        } else {
            response.setStatusCode(cachedResponse.statusCode());
        }
    }

    private boolean isRequestNoCache(HttpHeaders requestHeaders) {
        return requestHeaders.getCacheControl() != null && requestHeaders.getCacheControl().contains(NO_CACHE_VALUE);
    }
}

