/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.sql;

import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.CoreSocketFactory;
import com.google.cloud.sql.postgres.SocketFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.Driver;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JndiDataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.core.GcpProperties;
import org.springframework.cloud.gcp.autoconfigure.sql.CloudSqlJdbcInfoProvider;
import org.springframework.cloud.gcp.autoconfigure.sql.DatabaseType;
import org.springframework.cloud.gcp.autoconfigure.sql.DefaultCloudSqlJdbcInfoProvider;
import org.springframework.cloud.gcp.autoconfigure.sql.GcpCloudSqlProperties;
import org.springframework.cloud.gcp.autoconfigure.sql.SqlCredentialFactory;
import org.springframework.cloud.gcp.core.Credentials;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class, CredentialFactory.class})
@ConditionalOnProperty(name={"spring.cloud.gcp.sql.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GcpCloudSqlProperties.class, DataSourceProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, JndiDataSourceAutoConfiguration.class, XADataSourceAutoConfiguration.class})
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
public class GcpCloudSqlAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(GcpCloudSqlAutoConfiguration.class);

    @Configuration(proxyBeanMethods=false)
    @Import(value={MySqlJdbcInfoProviderConfiguration.class, PostgreSqlJdbcInfoProviderConfiguration.class})
    static class CloudSqlDataSourcePropertiesConfiguration {
        CloudSqlDataSourcePropertiesConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnBean(value={CloudSqlJdbcInfoProvider.class})
        public DataSourceProperties cloudSqlDataSourceProperties(GcpCloudSqlProperties gcpCloudSqlProperties, DataSourceProperties properties, GcpProperties gcpProperties, CloudSqlJdbcInfoProvider cloudSqlJdbcInfoProvider, ConfigurableEnvironment configurableEnvironment) {
            if (StringUtils.isEmpty((Object)properties.getUsername())) {
                properties.setUsername("root");
                LOGGER.warn((Object)"spring.datasource.username is not specified. Setting default username.");
            }
            if (StringUtils.isEmpty((Object)properties.getDriverClassName())) {
                properties.setDriverClassName(cloudSqlJdbcInfoProvider.getJdbcDriverClass());
            } else {
                LOGGER.warn((Object)"spring.datasource.driver-class-name is specified. Not using generated Cloud SQL configuration");
            }
            if (StringUtils.hasText((String)properties.getUrl())) {
                LOGGER.warn((Object)"Ignoring provided spring.datasource.url. Overwriting it based on the spring.cloud.gcp.sql.instance-connection-name.");
            }
            properties.setUrl(cloudSqlJdbcInfoProvider.getJdbcUrl());
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("spring.datasource.url", cloudSqlJdbcInfoProvider.getJdbcUrl());
            configurableEnvironment.getPropertySources().addFirst((PropertySource)new MapPropertySource("CLOUD_SQL_DATA_SOURCE_URL", myMap));
            if (gcpCloudSqlProperties.getCredentials().getEncodedKey() != null) {
                this.setCredentialsEncodedKeyProperty(gcpCloudSqlProperties);
            } else {
                this.setCredentialsFileProperty(gcpCloudSqlProperties, gcpProperties);
            }
            CoreSocketFactory.setApplicationName((String)("spring-cloud-gcp-sql/" + this.getClass().getPackage().getImplementationVersion()));
            return properties;
        }

        private void setCredentialsFileProperty(GcpCloudSqlProperties gcpCloudSqlProperties, GcpProperties gcpProperties) {
            try {
                if (gcpCloudSqlProperties.getCredentials().getLocation() != null) {
                    File credentialsLocationFile = gcpCloudSqlProperties.getCredentials().getLocation().getFile();
                    this.setSystemProperties(credentialsLocationFile);
                } else if (gcpProperties != null && gcpProperties.getCredentials().getLocation() != null) {
                    File credentialsLocationFile = gcpProperties.getCredentials().getLocation().getFile();
                    this.setSystemProperties(credentialsLocationFile);
                }
            }
            catch (IOException ioe) {
                LOGGER.info((Object)"Error reading Cloud SQL credentials file.", (Throwable)ioe);
            }
        }

        private void setSystemProperties(File credentialsLocationFile) {
            if (credentialsLocationFile == null) {
                LOGGER.info((Object)"The private key of the Google Cloud SQL credential must be in a file on the filesystem.");
                return;
            }
            System.setProperty("GOOGLE_CLOUD_SQL_CREDS_LOCATION", credentialsLocationFile.getAbsolutePath());
            System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
        }

        private void setCredentialsEncodedKeyProperty(GcpCloudSqlProperties gcpCloudSqlProperties) {
            Credentials credentials = gcpCloudSqlProperties.getCredentials();
            if (credentials.getEncodedKey() == null) {
                LOGGER.info((Object)"SQL properties contain no encoded key. Can't set credentials.");
                return;
            }
            System.setProperty("GOOGLE_CLOUD_SQL_ENCODED_KEY", credentials.getEncodedKey());
            System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
        }
    }

    @ConditionalOnClass(value={SocketFactory.class, Driver.class})
    @ConditionalOnMissingBean(value={CloudSqlJdbcInfoProvider.class})
    static class PostgreSqlJdbcInfoProviderConfiguration {
        PostgreSqlJdbcInfoProviderConfiguration() {
        }

        @Bean
        public CloudSqlJdbcInfoProvider defaultPostgreSqlJdbcInfoProvider(GcpCloudSqlProperties gcpCloudSqlProperties) {
            DefaultCloudSqlJdbcInfoProvider defaultProvider = new DefaultCloudSqlJdbcInfoProvider(gcpCloudSqlProperties, DatabaseType.POSTGRESQL);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Default " + DatabaseType.POSTGRESQL.name() + " JdbcUrl provider. Connecting to " + defaultProvider.getJdbcUrl() + " with driver " + defaultProvider.getJdbcDriverClass()));
            }
            return defaultProvider;
        }
    }

    @ConditionalOnClass(value={com.google.cloud.sql.mysql.SocketFactory.class, com.mysql.cj.jdbc.Driver.class})
    @ConditionalOnMissingBean(value={CloudSqlJdbcInfoProvider.class})
    static class MySqlJdbcInfoProviderConfiguration {
        MySqlJdbcInfoProviderConfiguration() {
        }

        @Bean
        public CloudSqlJdbcInfoProvider defaultMySqlJdbcInfoProvider(GcpCloudSqlProperties gcpCloudSqlProperties) {
            DefaultCloudSqlJdbcInfoProvider defaultProvider = new DefaultCloudSqlJdbcInfoProvider(gcpCloudSqlProperties, DatabaseType.MYSQL);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Default " + DatabaseType.MYSQL.name() + " JdbcUrl provider. Connecting to " + defaultProvider.getJdbcUrl() + " with driver " + defaultProvider.getJdbcDriverClass()));
            }
            return defaultProvider;
        }
    }
}

