/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;

public class EurekaHealthIndicator
implements DiscoveryHealthIndicator {
    private final EurekaClient eurekaClient;
    private final EurekaInstanceConfig instanceConfig;
    private final EurekaClientConfig clientConfig;

    public EurekaHealthIndicator(EurekaClient eurekaClient, EurekaInstanceConfig instanceConfig, EurekaClientConfig clientConfig) {
        this.eurekaClient = eurekaClient;
        this.instanceConfig = instanceConfig;
        this.clientConfig = clientConfig;
    }

    public String getName() {
        return "eureka";
    }

    public Health health() {
        Health.Builder builder = Health.unknown();
        Status status = this.getStatus(builder);
        return builder.status(status).withDetail("applications", this.getApplications()).build();
    }

    private Status getStatus(Health.Builder builder) {
        Status status = new Status(this.eurekaClient.getInstanceRemoteStatus().toString(), "Remote status from Eureka server");
        if (this.eurekaClient instanceof DiscoveryClient && this.clientConfig.shouldFetchRegistry()) {
            DiscoveryClient discoveryClient = (DiscoveryClient)this.eurekaClient;
            long lastFetch = discoveryClient.getLastSuccessfulRegistryFetchTimePeriod();
            if (lastFetch < 0L) {
                status = new Status("UP", "Eureka discovery client has not yet successfully connected to a Eureka server");
            } else if (lastFetch > (long)(this.clientConfig.getRegistryFetchIntervalSeconds() * 2)) {
                status = new Status("UP", "Eureka discovery client is reporting failures to connect to a Eureka server");
                builder.withDetail("renewalPeriod", (Object)this.instanceConfig.getLeaseRenewalIntervalInSeconds());
                builder.withDetail("failCount", (Object)(lastFetch / (long)this.clientConfig.getRegistryFetchIntervalSeconds()));
            }
        }
        return status;
    }

    private Map<String, Object> getApplications() {
        Applications applications = this.eurekaClient.getApplications();
        if (applications == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Application application : applications.getRegisteredApplications()) {
            result.put(application.getName(), application.getInstances().size());
        }
        return result;
    }
}

