/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="eureka.instance")
public class EurekaInstanceConfigBean
implements CloudEurekaInstanceConfig,
EnvironmentAware {
    private static final String UNKNOWN = "unknown";
    private InetUtils.HostInfo hostInfo;
    private InetUtils inetUtils;
    private String appname = "unknown";
    private String appGroupName;
    private boolean instanceEnabledOnit;
    private int nonSecurePort = 80;
    private int securePort = 443;
    private boolean nonSecurePortEnabled = true;
    private boolean securePortEnabled;
    private int leaseRenewalIntervalInSeconds = 30;
    private int leaseExpirationDurationInSeconds = 90;
    private String virtualHostName = "unknown";
    private String instanceId;
    private String secureVirtualHostName = "unknown";
    private String aSGName;
    private Map<String, String> metadataMap = new HashMap<String, String>();
    private DataCenterInfo dataCenterInfo = new MyDataCenterInfo(DataCenterInfo.Name.MyOwn);
    private String ipAddress;
    private String statusPageUrlPath = "/info";
    private String statusPageUrl;
    private String homePageUrlPath = "/";
    private String homePageUrl;
    private String healthCheckUrlPath = "/health";
    private String healthCheckUrl;
    private String secureHealthCheckUrl;
    private String namespace = "eureka";
    private String hostname;
    private boolean preferIpAddress = false;
    private InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.UP;
    private String[] defaultAddressResolutionOrder = new String[0];
    private Environment environment;

    public String getHostname() {
        return this.getHostName(false);
    }

    private EurekaInstanceConfigBean() {
    }

    public EurekaInstanceConfigBean(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
        this.hostInfo = this.inetUtils.findFirstNonLoopbackHostInfo();
        this.ipAddress = this.hostInfo.getIpAddress();
        this.hostname = this.hostInfo.getHostname();
    }

    public String getInstanceId() {
        if (this.instanceId == null && this.metadataMap != null) {
            return this.metadataMap.get("instanceId");
        }
        return this.instanceId;
    }

    public boolean getSecurePortEnabled() {
        return this.securePortEnabled;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.hostInfo.override = true;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostInfo.override = true;
    }

    public String getHostName(boolean refresh) {
        if (refresh && !this.hostInfo.override) {
            this.ipAddress = this.hostInfo.getIpAddress();
            this.hostname = this.hostInfo.getHostname();
        }
        return this.preferIpAddress ? this.ipAddress : this.hostname;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        RelaxedPropertyResolver springPropertyResolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "spring.application.");
        String springAppName = springPropertyResolver.getProperty("name");
        if (StringUtils.hasText((String)springAppName)) {
            this.setAppname(springAppName);
            this.setVirtualHostName(springAppName);
            this.setSecureVirtualHostName(springAppName);
        }
    }

    public String getAppname() {
        return this.appname;
    }

    public String getAppGroupName() {
        return this.appGroupName;
    }

    public boolean isInstanceEnabledOnit() {
        return this.instanceEnabledOnit;
    }

    public int getNonSecurePort() {
        return this.nonSecurePort;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public boolean isNonSecurePortEnabled() {
        return this.nonSecurePortEnabled;
    }

    public int getLeaseRenewalIntervalInSeconds() {
        return this.leaseRenewalIntervalInSeconds;
    }

    public int getLeaseExpirationDurationInSeconds() {
        return this.leaseExpirationDurationInSeconds;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getSecureVirtualHostName() {
        return this.secureVirtualHostName;
    }

    public String getASGName() {
        return this.aSGName;
    }

    public Map<String, String> getMetadataMap() {
        return this.metadataMap;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getStatusPageUrlPath() {
        return this.statusPageUrlPath;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    public String getHomePageUrlPath() {
        return this.homePageUrlPath;
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getHealthCheckUrlPath() {
        return this.healthCheckUrlPath;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public String getSecureHealthCheckUrl() {
        return this.secureHealthCheckUrl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    @Override
    public InstanceInfo.InstanceStatus getInitialStatus() {
        return this.initialStatus;
    }

    public String[] getDefaultAddressResolutionOrder() {
        return this.defaultAddressResolutionOrder;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public void setAppGroupName(String appGroupName) {
        this.appGroupName = appGroupName;
    }

    public void setInstanceEnabledOnit(boolean instanceEnabledOnit) {
        this.instanceEnabledOnit = instanceEnabledOnit;
    }

    @Override
    public void setNonSecurePort(int nonSecurePort) {
        this.nonSecurePort = nonSecurePort;
    }

    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public void setNonSecurePortEnabled(boolean nonSecurePortEnabled) {
        this.nonSecurePortEnabled = nonSecurePortEnabled;
    }

    public void setSecurePortEnabled(boolean securePortEnabled) {
        this.securePortEnabled = securePortEnabled;
    }

    public void setLeaseRenewalIntervalInSeconds(int leaseRenewalIntervalInSeconds) {
        this.leaseRenewalIntervalInSeconds = leaseRenewalIntervalInSeconds;
    }

    public void setLeaseExpirationDurationInSeconds(int leaseExpirationDurationInSeconds) {
        this.leaseExpirationDurationInSeconds = leaseExpirationDurationInSeconds;
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setSecureVirtualHostName(String secureVirtualHostName) {
        this.secureVirtualHostName = secureVirtualHostName;
    }

    public void setASGName(String aSGName) {
        this.aSGName = aSGName;
    }

    public void setMetadataMap(Map<String, String> metadataMap) {
        this.metadataMap = metadataMap;
    }

    public void setDataCenterInfo(DataCenterInfo dataCenterInfo) {
        this.dataCenterInfo = dataCenterInfo;
    }

    public void setStatusPageUrlPath(String statusPageUrlPath) {
        this.statusPageUrlPath = statusPageUrlPath;
    }

    public void setStatusPageUrl(String statusPageUrl) {
        this.statusPageUrl = statusPageUrl;
    }

    public void setHomePageUrlPath(String homePageUrlPath) {
        this.homePageUrlPath = homePageUrlPath;
    }

    public void setHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
    }

    public void setHealthCheckUrlPath(String healthCheckUrlPath) {
        this.healthCheckUrlPath = healthCheckUrlPath;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public void setSecureHealthCheckUrl(String secureHealthCheckUrl) {
        this.secureHealthCheckUrl = secureHealthCheckUrl;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public void setInitialStatus(InstanceInfo.InstanceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public void setDefaultAddressResolutionOrder(String[] defaultAddressResolutionOrder) {
        this.defaultAddressResolutionOrder = defaultAddressResolutionOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EurekaInstanceConfigBean)) {
            return false;
        }
        EurekaInstanceConfigBean other = (EurekaInstanceConfigBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InetUtils.HostInfo this$hostInfo = this.getHostInfo();
        InetUtils.HostInfo other$hostInfo = other.getHostInfo();
        if (this$hostInfo == null ? other$hostInfo != null : !this$hostInfo.equals(other$hostInfo)) {
            return false;
        }
        InetUtils this$inetUtils = this.getInetUtils();
        InetUtils other$inetUtils = other.getInetUtils();
        if (this$inetUtils == null ? other$inetUtils != null : !this$inetUtils.equals(other$inetUtils)) {
            return false;
        }
        String this$appname = this.getAppname();
        String other$appname = other.getAppname();
        if (this$appname == null ? other$appname != null : !this$appname.equals(other$appname)) {
            return false;
        }
        String this$appGroupName = this.getAppGroupName();
        String other$appGroupName = other.getAppGroupName();
        if (this$appGroupName == null ? other$appGroupName != null : !this$appGroupName.equals(other$appGroupName)) {
            return false;
        }
        if (this.isInstanceEnabledOnit() != other.isInstanceEnabledOnit()) {
            return false;
        }
        if (this.getNonSecurePort() != other.getNonSecurePort()) {
            return false;
        }
        if (this.getSecurePort() != other.getSecurePort()) {
            return false;
        }
        if (this.isNonSecurePortEnabled() != other.isNonSecurePortEnabled()) {
            return false;
        }
        if (this.getSecurePortEnabled() != other.getSecurePortEnabled()) {
            return false;
        }
        if (this.getLeaseRenewalIntervalInSeconds() != other.getLeaseRenewalIntervalInSeconds()) {
            return false;
        }
        if (this.getLeaseExpirationDurationInSeconds() != other.getLeaseExpirationDurationInSeconds()) {
            return false;
        }
        String this$virtualHostName = this.getVirtualHostName();
        String other$virtualHostName = other.getVirtualHostName();
        if (this$virtualHostName == null ? other$virtualHostName != null : !this$virtualHostName.equals(other$virtualHostName)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$secureVirtualHostName = this.getSecureVirtualHostName();
        String other$secureVirtualHostName = other.getSecureVirtualHostName();
        if (this$secureVirtualHostName == null ? other$secureVirtualHostName != null : !this$secureVirtualHostName.equals(other$secureVirtualHostName)) {
            return false;
        }
        String this$aSGName = this.getASGName();
        String other$aSGName = other.getASGName();
        if (this$aSGName == null ? other$aSGName != null : !this$aSGName.equals(other$aSGName)) {
            return false;
        }
        Map<String, String> this$metadataMap = this.getMetadataMap();
        Map<String, String> other$metadataMap = other.getMetadataMap();
        if (this$metadataMap == null ? other$metadataMap != null : !((Object)this$metadataMap).equals(other$metadataMap)) {
            return false;
        }
        DataCenterInfo this$dataCenterInfo = this.getDataCenterInfo();
        DataCenterInfo other$dataCenterInfo = other.getDataCenterInfo();
        if (this$dataCenterInfo == null ? other$dataCenterInfo != null : !this$dataCenterInfo.equals(other$dataCenterInfo)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$statusPageUrlPath = this.getStatusPageUrlPath();
        String other$statusPageUrlPath = other.getStatusPageUrlPath();
        if (this$statusPageUrlPath == null ? other$statusPageUrlPath != null : !this$statusPageUrlPath.equals(other$statusPageUrlPath)) {
            return false;
        }
        String this$statusPageUrl = this.getStatusPageUrl();
        String other$statusPageUrl = other.getStatusPageUrl();
        if (this$statusPageUrl == null ? other$statusPageUrl != null : !this$statusPageUrl.equals(other$statusPageUrl)) {
            return false;
        }
        String this$homePageUrlPath = this.getHomePageUrlPath();
        String other$homePageUrlPath = other.getHomePageUrlPath();
        if (this$homePageUrlPath == null ? other$homePageUrlPath != null : !this$homePageUrlPath.equals(other$homePageUrlPath)) {
            return false;
        }
        String this$homePageUrl = this.getHomePageUrl();
        String other$homePageUrl = other.getHomePageUrl();
        if (this$homePageUrl == null ? other$homePageUrl != null : !this$homePageUrl.equals(other$homePageUrl)) {
            return false;
        }
        String this$healthCheckUrlPath = this.getHealthCheckUrlPath();
        String other$healthCheckUrlPath = other.getHealthCheckUrlPath();
        if (this$healthCheckUrlPath == null ? other$healthCheckUrlPath != null : !this$healthCheckUrlPath.equals(other$healthCheckUrlPath)) {
            return false;
        }
        String this$healthCheckUrl = this.getHealthCheckUrl();
        String other$healthCheckUrl = other.getHealthCheckUrl();
        if (this$healthCheckUrl == null ? other$healthCheckUrl != null : !this$healthCheckUrl.equals(other$healthCheckUrl)) {
            return false;
        }
        String this$secureHealthCheckUrl = this.getSecureHealthCheckUrl();
        String other$secureHealthCheckUrl = other.getSecureHealthCheckUrl();
        if (this$secureHealthCheckUrl == null ? other$secureHealthCheckUrl != null : !this$secureHealthCheckUrl.equals(other$secureHealthCheckUrl)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        if (this.isPreferIpAddress() != other.isPreferIpAddress()) {
            return false;
        }
        InstanceInfo.InstanceStatus this$initialStatus = this.getInitialStatus();
        InstanceInfo.InstanceStatus other$initialStatus = other.getInitialStatus();
        if (this$initialStatus == null ? other$initialStatus != null : !this$initialStatus.equals(other$initialStatus)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDefaultAddressResolutionOrder(), other.getDefaultAddressResolutionOrder())) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EurekaInstanceConfigBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InetUtils.HostInfo $hostInfo = this.getHostInfo();
        result = result * 59 + ($hostInfo == null ? 43 : $hostInfo.hashCode());
        InetUtils $inetUtils = this.getInetUtils();
        result = result * 59 + ($inetUtils == null ? 43 : $inetUtils.hashCode());
        String $appname = this.getAppname();
        result = result * 59 + ($appname == null ? 43 : $appname.hashCode());
        String $appGroupName = this.getAppGroupName();
        result = result * 59 + ($appGroupName == null ? 43 : $appGroupName.hashCode());
        result = result * 59 + (this.isInstanceEnabledOnit() ? 79 : 97);
        result = result * 59 + this.getNonSecurePort();
        result = result * 59 + this.getSecurePort();
        result = result * 59 + (this.isNonSecurePortEnabled() ? 79 : 97);
        result = result * 59 + (this.getSecurePortEnabled() ? 79 : 97);
        result = result * 59 + this.getLeaseRenewalIntervalInSeconds();
        result = result * 59 + this.getLeaseExpirationDurationInSeconds();
        String $virtualHostName = this.getVirtualHostName();
        result = result * 59 + ($virtualHostName == null ? 43 : $virtualHostName.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $secureVirtualHostName = this.getSecureVirtualHostName();
        result = result * 59 + ($secureVirtualHostName == null ? 43 : $secureVirtualHostName.hashCode());
        String $aSGName = this.getASGName();
        result = result * 59 + ($aSGName == null ? 43 : $aSGName.hashCode());
        Map<String, String> $metadataMap = this.getMetadataMap();
        result = result * 59 + ($metadataMap == null ? 43 : ((Object)$metadataMap).hashCode());
        DataCenterInfo $dataCenterInfo = this.getDataCenterInfo();
        result = result * 59 + ($dataCenterInfo == null ? 43 : $dataCenterInfo.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $statusPageUrlPath = this.getStatusPageUrlPath();
        result = result * 59 + ($statusPageUrlPath == null ? 43 : $statusPageUrlPath.hashCode());
        String $statusPageUrl = this.getStatusPageUrl();
        result = result * 59 + ($statusPageUrl == null ? 43 : $statusPageUrl.hashCode());
        String $homePageUrlPath = this.getHomePageUrlPath();
        result = result * 59 + ($homePageUrlPath == null ? 43 : $homePageUrlPath.hashCode());
        String $homePageUrl = this.getHomePageUrl();
        result = result * 59 + ($homePageUrl == null ? 43 : $homePageUrl.hashCode());
        String $healthCheckUrlPath = this.getHealthCheckUrlPath();
        result = result * 59 + ($healthCheckUrlPath == null ? 43 : $healthCheckUrlPath.hashCode());
        String $healthCheckUrl = this.getHealthCheckUrl();
        result = result * 59 + ($healthCheckUrl == null ? 43 : $healthCheckUrl.hashCode());
        String $secureHealthCheckUrl = this.getSecureHealthCheckUrl();
        result = result * 59 + ($secureHealthCheckUrl == null ? 43 : $secureHealthCheckUrl.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        result = result * 59 + (this.isPreferIpAddress() ? 79 : 97);
        InstanceInfo.InstanceStatus $initialStatus = this.getInitialStatus();
        result = result * 59 + ($initialStatus == null ? 43 : $initialStatus.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultAddressResolutionOrder());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "EurekaInstanceConfigBean(hostInfo=" + this.getHostInfo() + ", inetUtils=" + this.getInetUtils() + ", appname=" + this.getAppname() + ", appGroupName=" + this.getAppGroupName() + ", instanceEnabledOnit=" + this.isInstanceEnabledOnit() + ", nonSecurePort=" + this.getNonSecurePort() + ", securePort=" + this.getSecurePort() + ", nonSecurePortEnabled=" + this.isNonSecurePortEnabled() + ", securePortEnabled=" + this.getSecurePortEnabled() + ", leaseRenewalIntervalInSeconds=" + this.getLeaseRenewalIntervalInSeconds() + ", leaseExpirationDurationInSeconds=" + this.getLeaseExpirationDurationInSeconds() + ", virtualHostName=" + this.getVirtualHostName() + ", instanceId=" + this.getInstanceId() + ", secureVirtualHostName=" + this.getSecureVirtualHostName() + ", aSGName=" + this.getASGName() + ", metadataMap=" + this.getMetadataMap() + ", dataCenterInfo=" + this.getDataCenterInfo() + ", ipAddress=" + this.getIpAddress() + ", statusPageUrlPath=" + this.getStatusPageUrlPath() + ", statusPageUrl=" + this.getStatusPageUrl() + ", homePageUrlPath=" + this.getHomePageUrlPath() + ", homePageUrl=" + this.getHomePageUrl() + ", healthCheckUrlPath=" + this.getHealthCheckUrlPath() + ", healthCheckUrl=" + this.getHealthCheckUrl() + ", secureHealthCheckUrl=" + this.getSecureHealthCheckUrl() + ", namespace=" + this.getNamespace() + ", hostname=" + this.getHostname() + ", preferIpAddress=" + this.isPreferIpAddress() + ", initialStatus=" + this.getInitialStatus() + ", defaultAddressResolutionOrder=" + Arrays.deepToString(this.getDefaultAddressResolutionOrder()) + ", environment=" + this.getEnvironment() + ")";
    }

    private InetUtils.HostInfo getHostInfo() {
        return this.hostInfo;
    }

    private void setHostInfo(InetUtils.HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    private InetUtils getInetUtils() {
        return this.inetUtils;
    }

    private void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }
}

