/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.cloud.netflix.eureka.http.WebClientEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.WebClientTransportClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration(proxyBeanMethods=false)
public class EurekaConfigServerBootstrapConfiguration {
    private static final Log log = LogFactory.getLog(EurekaConfigServerBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={EurekaClientConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaClientConfigBean eurekaClientConfigBean() {
        return new EurekaClientConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaHttpClient.class})
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public WebClientEurekaHttpClient configDiscoveryWebClientEurekaHttpClient(EurekaClientConfigBean config) {
        return (WebClientEurekaHttpClient)new WebClientTransportClientFactory().newClient((EurekaEndpoint)new DefaultEndpoint(this.getEurekaUrl(config)));
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaHttpClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.web.reactive.function.client.WebClient"})
    public RestTemplateEurekaHttpClient configDiscoveryRestTemplateEurekaHttpClient(EurekaClientConfigBean config) {
        return (RestTemplateEurekaHttpClient)new RestTemplateTransportClientFactory().newClient((EurekaEndpoint)new DefaultEndpoint(this.getEurekaUrl(config)));
    }

    private String getEurekaUrl(EurekaClientConfigBean config) {
        List urls = EndpointUtils.getServiceUrlsFromConfig((EurekaClientConfig)config, (String)"defaultZone", (boolean)true);
        return (String)urls.get(0);
    }

    private boolean isSuccessful(EurekaHttpResponse<Applications> response) {
        HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatusCode());
        return httpStatus != null && httpStatus.is2xxSuccessful();
    }

    @Bean
    public ConfigServerInstanceProvider.Function eurekaConfigServerInstanceProvider(EurekaHttpClient client, EurekaClientConfig config) {
        return serviceId -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("eurekaConfigServerInstanceProvider finding instances for " + serviceId));
            }
            EurekaHttpResponse response = client.getApplications(new String[]{config.getRegion()});
            ArrayList<EurekaServiceInstance> instances = new ArrayList<EurekaServiceInstance>();
            if (!this.isSuccessful((EurekaHttpResponse<Applications>)response) || response.getEntity() == null) {
                return instances;
            }
            Applications applications = (Applications)response.getEntity();
            applications.shuffleInstances(config.shouldFilterOnlyUpInstances());
            List infos = applications.getInstancesByVirtualHostName(serviceId);
            for (InstanceInfo info : infos) {
                instances.add(new EurekaServiceInstance(info));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("eurekaConfigServerInstanceProvider found " + infos.size() + " instance(s) for " + serviceId + ", " + instances));
            }
            return instances;
        };
    }
}

