/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.contrib.javanica.aop.aspectj.HystrixCommandAspect;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import com.netflix.hystrix.metric.consumer.HystrixDashboardStream;
import com.netflix.hystrix.serial.SerialHystrixDashboardData;
import io.micrometer.core.instrument.binder.hystrix.HystrixMetricsBinder;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.hystrix.HystrixHealthIndicator;
import org.springframework.cloud.netflix.hystrix.HystrixProperties;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;
import org.springframework.cloud.netflix.hystrix.HystrixWebfluxEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;
import rx.Observable;
import rx.RxReactiveStreams;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Hystrix.class, HealthIndicator.class, HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={HealthIndicatorAutoConfiguration.class})
public class HystrixAutoConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="hystrix")
    public HystrixHealthIndicator hystrixHealthIndicator() {
        return new HystrixHealthIndicator();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnBean(value={HystrixCommandAspect.class})
    @ConditionalOnClass(value={DispatcherHandler.class})
    @EnableConfigurationProperties(value={HystrixProperties.class})
    protected static class HystrixWebfluxManagementContextConfiguration {
        protected HystrixWebfluxManagementContextConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledEndpoint
        public HystrixWebfluxEndpoint hystrixWebfluxController() {
            Observable serializedDashboardData = HystrixDashboardStream.getInstance().observe().concatMap(dashboardData -> Observable.from((Iterable)SerialHystrixDashboardData.toMultipleJsonStrings((HystrixDashboardStream.DashboardData)dashboardData)));
            Publisher publisher = RxReactiveStreams.toPublisher((Observable)serializedDashboardData);
            return new HystrixWebfluxEndpoint((Publisher<String>)publisher);
        }

        @Bean
        public HasFeatures hystrixStreamFeature() {
            return HasFeatures.namedFeature((String)"Hystrix Stream Webflux", HystrixWebfluxEndpoint.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnBean(value={HystrixCommandAspect.class})
    @ConditionalOnClass(value={HystrixMetricsStreamServlet.class})
    @EnableConfigurationProperties(value={HystrixProperties.class})
    protected static class HystrixServletAutoConfiguration {
        protected HystrixServletAutoConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledEndpoint
        public HystrixStreamEndpoint hystrixStreamEndpoint(HystrixProperties properties) {
            return new HystrixStreamEndpoint(properties.getConfig());
        }

        @Bean
        public HasFeatures hystrixStreamFeature() {
            return HasFeatures.namedFeature((String)"Hystrix Stream Servlet", HystrixMetricsStreamServlet.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"management.metrics.binders.hystrix.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HystrixMetricsBinder.class})
    protected static class HystrixMetricsConfiguration {
        protected HystrixMetricsConfiguration() {
        }

        @Bean
        public HystrixMetricsBinder hystrixMetricsBinder() {
            return new HystrixMetricsBinder();
        }
    }
}

