/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import java.util.function.Function;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.netflix.hystrix.AbstractHystrixConfigBuilder;
import org.springframework.cloud.netflix.hystrix.ReactiveHystrixCircuitBreaker;
import org.springframework.util.Assert;

public class ReactiveHystrixCircuitBreakerFactory
extends ReactiveCircuitBreakerFactory<HystrixObservableCommand.Setter, ReactiveHystrixConfigBuilder> {
    private Function<String, HystrixObservableCommand.Setter> defaultConfiguration = id -> HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)((Object)((Object)this)).getClass().getSimpleName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)id));

    protected ReactiveHystrixConfigBuilder configBuilder(String id) {
        return new ReactiveHystrixConfigBuilder(id);
    }

    public void configureDefault(Function<String, HystrixObservableCommand.Setter> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public ReactiveCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        HystrixObservableCommand.Setter setter = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new ReactiveHystrixCircuitBreaker(setter);
    }

    public static class ReactiveHystrixConfigBuilder
    extends AbstractHystrixConfigBuilder<HystrixObservableCommand.Setter> {
        public ReactiveHystrixConfigBuilder(String id) {
            super(id);
        }

        public HystrixObservableCommand.Setter build() {
            return HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)this.getGroupKey()).andCommandKey(this.getCommandKey()).andCommandPropertiesDefaults(this.getCommandPropertiesSetter());
        }
    }
}

