/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import com.netflix.zuul.http.ServletInputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.pre.Servlet30RequestWrapper;
import org.springframework.cloud.netflix.zuul.util.RequestContentDataExtractor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.DispatcherServlet;

public class FormBodyWrapperFilter
extends ZuulFilter {
    private FormHttpMessageConverter formHttpMessageConverter;
    private Field requestField;
    private Field servletRequestField;

    public FormBodyWrapperFilter() {
        this((FormHttpMessageConverter)new AllEncompassingFormHttpMessageConverter());
    }

    public FormBodyWrapperFilter(FormHttpMessageConverter formHttpMessageConverter) {
        this.formHttpMessageConverter = formHttpMessageConverter;
        this.requestField = ReflectionUtils.findField(HttpServletRequestWrapper.class, (String)"req", HttpServletRequest.class);
        this.servletRequestField = ReflectionUtils.findField(ServletRequestWrapper.class, (String)"request", ServletRequest.class);
        Assert.notNull((Object)this.requestField, (String)"HttpServletRequestWrapper.req field not found");
        Assert.notNull((Object)this.servletRequestField, (String)"ServletRequestWrapper.request field not found");
        this.requestField.setAccessible(true);
        this.servletRequestField.setAccessible(true);
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.valueOf((String)contentType);
            return MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType) || this.isDispatcherServletRequest(request) && MediaType.MULTIPART_FORM_DATA.includes(mediaType);
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    private boolean isDispatcherServletRequest(HttpServletRequest request) {
        return request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        FormBodyRequestWrapper wrapper = null;
        if (request instanceof HttpServletRequestWrapper) {
            HttpServletRequest wrapped = (HttpServletRequest)ReflectionUtils.getField((Field)this.requestField, (Object)request);
            wrapper = new FormBodyRequestWrapper(wrapped);
            ReflectionUtils.setField((Field)this.requestField, (Object)request, (Object)((Object)wrapper));
            if (request instanceof ServletRequestWrapper) {
                ReflectionUtils.setField((Field)this.servletRequestField, (Object)request, (Object)((Object)wrapper));
            }
        } else {
            wrapper = new FormBodyRequestWrapper(request);
            ctx.setRequest((HttpServletRequest)wrapper);
        }
        if (wrapper != null) {
            ctx.getZuulRequestHeaders().put("content-type", wrapper.getContentType());
        }
        return null;
    }

    private class FormBodyRequestWrapper
    extends Servlet30RequestWrapper {
        private HttpServletRequest request;
        private volatile byte[] contentData;
        private MediaType contentType;
        private int contentLength;

        FormBodyRequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public String getContentType() {
            if (this.contentData == null) {
                this.buildContentData();
            }
            return this.contentType.toString();
        }

        public int getContentLength() {
            if (super.getContentLength() <= 0) {
                return super.getContentLength();
            }
            if (this.contentData == null) {
                this.buildContentData();
            }
            return this.contentLength;
        }

        public long getContentLengthLong() {
            return this.getContentLength();
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.contentData == null) {
                this.buildContentData();
            }
            return new ServletInputStreamWrapper(this.contentData);
        }

        private synchronized void buildContentData() {
            if (this.contentData != null) {
                return;
            }
            try {
                MultiValueMap<String, Object> builder = RequestContentDataExtractor.extract(this.request);
                FormHttpOutputMessage data = new FormHttpOutputMessage();
                this.contentType = MediaType.valueOf((String)this.request.getContentType());
                data.getHeaders().setContentType(this.contentType);
                FormBodyWrapperFilter.this.formHttpMessageConverter.write(builder, this.contentType, (HttpOutputMessage)data);
                this.contentType = data.getHeaders().getContentType();
                byte[] input = data.getInput();
                this.contentLength = input.length;
                this.contentData = input;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert form data", e);
            }
        }

        private class FormHttpOutputMessage
        implements HttpOutputMessage {
            private HttpHeaders headers = new HttpHeaders();
            private ByteArrayOutputStream output = new ByteArrayOutputStream();

            private FormHttpOutputMessage() {
            }

            public HttpHeaders getHeaders() {
                return this.headers;
            }

            public OutputStream getBody() throws IOException {
                return this.output;
            }

            public byte[] getInput() throws IOException {
                this.output.flush();
                return this.output.toByteArray();
            }
        }
    }
}

