/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class NodeClientFactoryBean
implements FactoryBean<NodeClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(NodeClientFactoryBean.class);
    private boolean local;
    private boolean enableHttp;
    private String clusterName;
    private NodeClient nodeClient;
    private String pathData;
    private String pathHome;
    private String pathConfiguration;

    NodeClientFactoryBean() {
    }

    public NodeClientFactoryBean(boolean local) {
        this.local = local;
    }

    public NodeClient getObject() throws Exception {
        return this.nodeClient;
    }

    public Class<? extends Client> getObjectType() {
        return NodeClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.nodeClient = (NodeClient)NodeBuilder.nodeBuilder().settings(Settings.builder().put(this.loadConfig()).put("http.enabled", String.valueOf(this.enableHttp)).put("path.home", this.pathHome).put("path.data", this.pathData)).clusterName(this.clusterName).local(this.local).node().client();
    }

    private Settings loadConfig() {
        if (StringUtils.isNotBlank((String)this.pathConfiguration)) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.pathConfiguration);
            if (stream != null) {
                return Settings.builder().loadFromStream(this.pathConfiguration, this.getClass().getClassLoader().getResourceAsStream(this.pathConfiguration)).build();
            }
            logger.error(String.format("Unable to read node configuration from file [%s]", this.pathConfiguration));
        }
        return Settings.builder().build();
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setEnableHttp(boolean enableHttp) {
        this.enableHttp = enableHttp;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    public void setPathHome(String pathHome) {
        this.pathHome = pathHome;
    }

    public void setPathConfiguration(String configuration) {
        this.pathConfiguration = configuration;
    }

    public void destroy() throws Exception {
        try {
            logger.info("Closing elasticSearch  client");
            if (this.nodeClient != null) {
                this.nodeClient.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }
}

