/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RestClientFactoryBean
implements FactoryBean<RestHighLevelClient>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RestClientFactoryBean.class);
    private RestHighLevelClient client;
    private String hosts = "http://localhost:9200";
    static final String COMMA = ",";

    public void destroy() throws Exception {
        try {
            log.info("Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    public RestHighLevelClient getObject() throws Exception {
        return this.client;
    }

    public Class<?> getObjectType() {
        return RestHighLevelClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void buildClient() throws Exception {
        Assert.hasText((String)this.hosts, (String)"[Assertion Failed] At least one host must be set.");
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>();
        for (String host : this.hosts.split(COMMA)) {
            URL hostUrl = new URL(host);
            httpHosts.add(new HttpHost(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol()));
        }
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[httpHosts.size()])));
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getHosts() {
        return this.hosts;
    }
}

