/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.search.SearchHit;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public interface ResultsMapper
extends SearchResultMapper,
GetResultMapper,
MultiGetResultMapper {
    public EntityMapper getEntityMapper();

    default public ProjectionFactory getProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    @Nullable
    default public <T> T mapEntity(String source, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        try {
            return this.getEntityMapper().mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), e);
        }
    }

    @Override
    @Nullable
    default public <T> T mapGetResult(GetResult getResult, Class<T> type) {
        T mappedResult;
        if (getResult.isSourceEmpty()) {
            return null;
        }
        Map source = getResult.getSource();
        if (!source.containsKey("id") || source.get("id") == null) {
            source.put("id", getResult.getId());
        }
        if ((mappedResult = this.getEntityMapper().readObject(source, type)) == null) {
            return null;
        }
        if (type.isInterface() || !ClassUtils.isAssignableValue(type, mappedResult)) {
            return (T)this.getProjectionFactory().createProjection(type, mappedResult);
        }
        return type.cast(mappedResult);
    }

    @Override
    @Nullable
    default public <T> T mapSearchHit(SearchHit searchHit, Class<T> type) {
        T mappedResult;
        if (!searchHit.hasSource()) {
            return null;
        }
        Map source = searchHit.getSourceAsMap();
        if (!source.containsKey("id") || source.get("id") == null) {
            source.put("id", searchHit.getId());
        }
        if ((mappedResult = this.getEntityMapper().readObject(source, type)) == null) {
            return null;
        }
        if (type.isInterface()) {
            return (T)this.getProjectionFactory().createProjection(type, mappedResult);
        }
        return type.cast(mappedResult);
    }
}

