/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.IndexOptions;
import org.springframework.data.elasticsearch.annotations.IndexPrefixes;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.Similarity;
import org.springframework.data.elasticsearch.annotations.TermVector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class MappingParameters {
    static final String FIELD_PARAM_COERCE = "coerce";
    static final String FIELD_PARAM_COPY_TO = "copy_to";
    static final String FIELD_PARAM_DOC_VALUES = "doc_values";
    static final String FIELD_PARAM_DATA = "fielddata";
    static final String FIELD_PARAM_FORMAT = "format";
    static final String FIELD_PARAM_IGNORE_ABOVE = "ignore_above";
    static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    static final String FIELD_PARAM_INDEX = "index";
    static final String FIELD_PARAM_INDEX_OPTIONS = "index_options";
    static final String FIELD_PARAM_INDEX_PHRASES = "index_phrases";
    static final String FIELD_PARAM_INDEX_PREFIXES = "index_prefixes";
    static final String FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS = "min_chars";
    static final String FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS = "max_chars";
    static final String FIELD_PARAM_INDEX_ANALYZER = "analyzer";
    static final String FIELD_PARAM_NORMALIZER = "normalizer";
    static final String FIELD_PARAM_NORMS = "norms";
    static final String FIELD_PARAM_NULL_VALUE = "null_value";
    static final String FIELD_PARAMETER_NAME_POSITION_INCREMENT_GAP = "position_increment_gap";
    static final String FIELD_PARAM_SCALING_FACTOR = "scaling_factor";
    static final String FIELD_PARAM_SEARCH_ANALYZER = "search_analyzer";
    static final String FIELD_PARAM_STORE = "store";
    static final String FIELD_PARAM_SIMILARITY = "similarity";
    static final String FIELD_PARAM_TERM_VECTOR = "term_vector";
    static final String FIELD_PARAM_TYPE = "type";
    static final String FIELD_PARAM_MAX_SHINGLE_SIZE = "max_shingle_size";
    private boolean index = true;
    private boolean store = false;
    private boolean fielddata = false;
    private FieldType type = null;
    private DateFormat dateFormat = null;
    private String datePattern = null;
    private String analyzer = null;
    private String searchAnalyzer = null;
    private String normalizer = null;
    private String[] copyTo = null;
    private Integer ignoreAbove = null;
    private boolean coerce = true;
    private boolean docValues = true;
    private boolean ignoreMalformed = false;
    private IndexOptions indexOptions = null;
    boolean indexPhrases = false;
    private IndexPrefixes indexPrefixes = null;
    private boolean norms = true;
    private String nullValue = null;
    private Integer positionIncrementGap = null;
    private Similarity similarity = Similarity.Default;
    private TermVector termVector = TermVector.none;
    private double scalingFactor = 1.0;
    @Nullable
    private Integer maxShingleSize;

    public static MappingParameters from(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"annotation must not be null!");
        if (annotation instanceof Field) {
            return new MappingParameters((Field)annotation);
        }
        if (annotation instanceof InnerField) {
            return new MappingParameters((InnerField)annotation);
        }
        throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
    }

    private MappingParameters(Field field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.dateFormat = field.format();
        this.datePattern = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = field.copyTo();
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        if (field.indexPrefixes().length > 0) {
            this.indexPrefixes = field.indexPrefixes()[0];
        }
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
    }

    private MappingParameters(InnerField field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.dateFormat = field.format();
        this.datePattern = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        if (field.indexPrefixes().length > 0) {
            this.indexPrefixes = field.indexPrefixes()[0];
        }
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
    }

    public boolean isStore() {
        return this.store;
    }

    public void writeTypeAndParametersTo(XContentBuilder builder) throws IOException {
        Assert.notNull((Object)builder, (String)"builder must ot be null");
        if (this.fielddata) {
            builder.field(FIELD_PARAM_DATA, this.fielddata);
        }
        if (this.type != FieldType.Auto) {
            builder.field(FIELD_PARAM_TYPE, this.type.name().toLowerCase());
            if (this.type == FieldType.Date && this.dateFormat != DateFormat.none) {
                builder.field(FIELD_PARAM_FORMAT, this.dateFormat == DateFormat.custom ? this.datePattern : this.dateFormat.toString());
            }
        }
        if (!this.index) {
            builder.field(FIELD_PARAM_INDEX, this.index);
        }
        if (!StringUtils.isEmpty((Object)this.analyzer)) {
            builder.field(FIELD_PARAM_INDEX_ANALYZER, this.analyzer);
        }
        if (!StringUtils.isEmpty((Object)this.searchAnalyzer)) {
            builder.field(FIELD_PARAM_SEARCH_ANALYZER, this.searchAnalyzer);
        }
        if (!StringUtils.isEmpty((Object)this.normalizer)) {
            builder.field(FIELD_PARAM_NORMALIZER, this.normalizer);
        }
        if (this.copyTo != null && this.copyTo.length > 0) {
            builder.field(FIELD_PARAM_COPY_TO, (Object)this.copyTo);
        }
        if (this.ignoreAbove != null) {
            Assert.isTrue((this.ignoreAbove >= 0 ? 1 : 0) != 0, (String)"ignore_above must be a positive value");
            builder.field(FIELD_PARAM_IGNORE_ABOVE, this.ignoreAbove);
        }
        if (!this.coerce) {
            builder.field(FIELD_PARAM_COERCE, this.coerce);
        }
        if (!this.docValues) {
            builder.field(FIELD_PARAM_DOC_VALUES, this.docValues);
        }
        if (this.ignoreMalformed) {
            builder.field(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (this.indexOptions != IndexOptions.none) {
            builder.field(FIELD_PARAM_INDEX_OPTIONS, (Object)this.indexOptions);
        }
        if (this.indexPhrases) {
            builder.field(FIELD_PARAM_INDEX_PHRASES, this.indexPhrases);
        }
        if (this.indexPrefixes != null) {
            builder.startObject(FIELD_PARAM_INDEX_PREFIXES);
            if (this.indexPrefixes.minChars() != 2) {
                builder.field(FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS, this.indexPrefixes.minChars());
            }
            if (this.indexPrefixes.maxChars() != 2) {
                builder.field(FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS, this.indexPrefixes.maxChars());
            }
            builder.endObject();
        }
        if (!this.norms) {
            builder.field(FIELD_PARAM_NORMS, this.norms);
        }
        if (!StringUtils.isEmpty((Object)this.nullValue)) {
            builder.field(FIELD_PARAM_NULL_VALUE, this.nullValue);
        }
        if (this.positionIncrementGap != null && this.positionIncrementGap >= 0) {
            builder.field(FIELD_PARAMETER_NAME_POSITION_INCREMENT_GAP, this.positionIncrementGap);
        }
        if (this.similarity != Similarity.Default) {
            builder.field(FIELD_PARAM_SIMILARITY, (Object)this.similarity);
        }
        if (this.termVector != TermVector.none) {
            builder.field(FIELD_PARAM_TERM_VECTOR, (Object)this.termVector);
        }
        if (this.type == FieldType.Scaled_Float) {
            builder.field(FIELD_PARAM_SCALING_FACTOR, this.scalingFactor);
        }
        if (this.maxShingleSize != null) {
            builder.field(FIELD_PARAM_MAX_SHINGLE_SIZE, this.maxShingleSize);
        }
    }
}

