/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.IndexOptions;
import org.springframework.data.elasticsearch.annotations.IndexPrefixes;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.NullValueType;
import org.springframework.data.elasticsearch.annotations.Similarity;
import org.springframework.data.elasticsearch.annotations.TermVector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class MappingParameters {
    static final String FIELD_PARAM_COERCE = "coerce";
    static final String FIELD_PARAM_COPY_TO = "copy_to";
    static final String FIELD_PARAM_DATA = "fielddata";
    static final String FIELD_PARAM_DOC_VALUES = "doc_values";
    static final String FIELD_PARAM_EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    static final String FIELD_PARAM_ENABLED = "enabled";
    static final String FIELD_PARAM_FORMAT = "format";
    static final String FIELD_PARAM_IGNORE_ABOVE = "ignore_above";
    static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    static final String FIELD_PARAM_INDEX = "index";
    static final String FIELD_PARAM_INDEX_OPTIONS = "index_options";
    static final String FIELD_PARAM_INDEX_PHRASES = "index_phrases";
    static final String FIELD_PARAM_INDEX_PREFIXES = "index_prefixes";
    static final String FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS = "min_chars";
    static final String FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS = "max_chars";
    static final String FIELD_PARAM_INDEX_ANALYZER = "analyzer";
    static final String FIELD_PARAM_MAX_SHINGLE_SIZE = "max_shingle_size";
    static final String FIELD_PARAM_NORMALIZER = "normalizer";
    static final String FIELD_PARAM_NORMS = "norms";
    static final String FIELD_PARAM_NULL_VALUE = "null_value";
    static final String FIELD_PARAM_POSITION_INCREMENT_GAP = "position_increment_gap";
    static final String FIELD_PARAM_POSITIVE_SCORE_IMPACT = "positive_score_impact";
    static final String FIELD_PARAM_SCALING_FACTOR = "scaling_factor";
    static final String FIELD_PARAM_SEARCH_ANALYZER = "search_analyzer";
    static final String FIELD_PARAM_STORE = "store";
    static final String FIELD_PARAM_SIMILARITY = "similarity";
    static final String FIELD_PARAM_TERM_VECTOR = "term_vector";
    static final String FIELD_PARAM_TYPE = "type";
    private final String analyzer;
    private final boolean coerce;
    @Nullable
    private final String[] copyTo;
    private final String datePattern;
    private final boolean docValues;
    private final boolean eagerGlobalOrdinals;
    private final boolean enabled;
    private final boolean fielddata;
    private final DateFormat format;
    @Nullable
    private final Integer ignoreAbove;
    private final boolean ignoreMalformed;
    private final boolean index;
    private final IndexOptions indexOptions;
    private final boolean indexPhrases;
    @Nullable
    private final IndexPrefixes indexPrefixes;
    private final String normalizer;
    private final boolean norms;
    @Nullable
    private final Integer maxShingleSize;
    private final String nullValue;
    private final NullValueType nullValueType;
    private final Integer positionIncrementGap;
    private final boolean positiveScoreImpact;
    private final String searchAnalyzer;
    private final double scalingFactor;
    private final Similarity similarity;
    private final boolean store;
    private final TermVector termVector;
    private final FieldType type;

    public static MappingParameters from(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"annotation must not be null!");
        if (annotation instanceof Field) {
            return new MappingParameters((Field)annotation);
        }
        if (annotation instanceof InnerField) {
            return new MappingParameters((InnerField)annotation);
        }
        throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
    }

    private MappingParameters(Field field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.format = field.format();
        this.datePattern = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = field.copyTo();
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        Assert.isTrue((field.enabled() || this.type == FieldType.Object ? 1 : 0) != 0, (String)"enabled false is only allowed for field type object");
        this.enabled = field.enabled();
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    private MappingParameters(InnerField field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.format = field.format();
        this.datePattern = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = null;
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        this.enabled = true;
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    public boolean isStore() {
        return this.store;
    }

    public void writeTypeAndParametersTo(XContentBuilder builder) throws IOException {
        Assert.notNull((Object)builder, (String)"builder must ot be null");
        if (this.fielddata) {
            builder.field(FIELD_PARAM_DATA, this.fielddata);
        }
        if (this.type != FieldType.Auto) {
            builder.field(FIELD_PARAM_TYPE, this.type.name().toLowerCase());
            if (this.type == FieldType.Date && this.format != DateFormat.none) {
                builder.field(FIELD_PARAM_FORMAT, this.format == DateFormat.custom ? this.datePattern : this.format.toString());
            }
        }
        if (!this.index) {
            builder.field(FIELD_PARAM_INDEX, this.index);
        }
        if (!StringUtils.isEmpty((Object)this.analyzer)) {
            builder.field(FIELD_PARAM_INDEX_ANALYZER, this.analyzer);
        }
        if (!StringUtils.isEmpty((Object)this.searchAnalyzer)) {
            builder.field(FIELD_PARAM_SEARCH_ANALYZER, this.searchAnalyzer);
        }
        if (!StringUtils.isEmpty((Object)this.normalizer)) {
            builder.field(FIELD_PARAM_NORMALIZER, this.normalizer);
        }
        if (this.copyTo != null && this.copyTo.length > 0) {
            builder.field(FIELD_PARAM_COPY_TO, (Object)this.copyTo);
        }
        if (this.ignoreAbove != null) {
            Assert.isTrue((this.ignoreAbove >= 0 ? 1 : 0) != 0, (String)"ignore_above must be a positive value");
            builder.field(FIELD_PARAM_IGNORE_ABOVE, this.ignoreAbove);
        }
        if (!this.coerce) {
            builder.field(FIELD_PARAM_COERCE, this.coerce);
        }
        if (!this.docValues) {
            builder.field(FIELD_PARAM_DOC_VALUES, this.docValues);
        }
        if (this.ignoreMalformed) {
            builder.field(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (this.indexOptions != IndexOptions.none) {
            builder.field(FIELD_PARAM_INDEX_OPTIONS, (Object)this.indexOptions);
        }
        if (this.indexPhrases) {
            builder.field(FIELD_PARAM_INDEX_PHRASES, this.indexPhrases);
        }
        if (this.indexPrefixes != null) {
            builder.startObject(FIELD_PARAM_INDEX_PREFIXES);
            if (this.indexPrefixes.minChars() != 2) {
                builder.field(FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS, this.indexPrefixes.minChars());
            }
            if (this.indexPrefixes.maxChars() != 2) {
                builder.field(FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS, this.indexPrefixes.maxChars());
            }
            builder.endObject();
        }
        if (!this.norms) {
            builder.field(FIELD_PARAM_NORMS, this.norms);
        }
        if (!StringUtils.isEmpty((Object)this.nullValue)) {
            Object value;
            switch (this.nullValueType) {
                case Integer: {
                    value = Integer.valueOf(this.nullValue);
                    break;
                }
                case Long: {
                    value = Long.valueOf(this.nullValue);
                    break;
                }
                case Double: {
                    value = Double.valueOf(this.nullValue);
                    break;
                }
                default: {
                    value = this.nullValue;
                }
            }
            builder.field(FIELD_PARAM_NULL_VALUE, value);
        }
        if (this.positionIncrementGap != null && this.positionIncrementGap >= 0) {
            builder.field(FIELD_PARAM_POSITION_INCREMENT_GAP, this.positionIncrementGap);
        }
        if (this.similarity != Similarity.Default) {
            builder.field(FIELD_PARAM_SIMILARITY, (Object)this.similarity);
        }
        if (this.termVector != TermVector.none) {
            builder.field(FIELD_PARAM_TERM_VECTOR, (Object)this.termVector);
        }
        if (this.type == FieldType.Scaled_Float) {
            builder.field(FIELD_PARAM_SCALING_FACTOR, this.scalingFactor);
        }
        if (this.maxShingleSize != null) {
            builder.field(FIELD_PARAM_MAX_SHINGLE_SIZE, this.maxShingleSize);
        }
        if (!this.positiveScoreImpact) {
            builder.field(FIELD_PARAM_POSITIVE_SCORE_IMPACT, this.positiveScoreImpact);
        }
        if (!this.enabled) {
            builder.field(FIELD_PARAM_ENABLED, this.enabled);
        }
        if (this.eagerGlobalOrdinals) {
            builder.field(FIELD_PARAM_EAGER_GLOBAL_ORDINALS, this.eagerGlobalOrdinals);
        }
    }
}

