/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.client.util.ScrollState;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class StreamQueries {
    static <T> SearchHitsIterator<T> streamResults(final int maxCount, final SearchScrollHits<T> searchHits, final Function<String, SearchScrollHits<T>> continueScrollFunction, final Consumer<List<String>> clearScrollConsumer) {
        Assert.notNull(searchHits, (String)"searchHits must not be null.");
        Assert.notNull((Object)searchHits.getScrollId(), (String)"scrollId of searchHits must not be null.");
        Assert.notNull(continueScrollFunction, (String)"continueScrollFunction must not be null.");
        Assert.notNull(clearScrollConsumer, (String)"clearScrollConsumer must not be null.");
        final Aggregations aggregations = searchHits.getAggregations();
        final float maxScore = searchHits.getMaxScore();
        final long totalHits = searchHits.getTotalHits();
        final TotalHitsRelation totalHitsRelation = searchHits.getTotalHitsRelation();
        return new SearchHitsIterator<T>(){
            private volatile AtomicInteger currentCount = new AtomicInteger();
            private volatile Iterator<SearchHit<T>> currentScrollHits = searchHits.iterator();
            private volatile boolean continueScroll = this.currentScrollHits.hasNext();
            private volatile ScrollState scrollState = new ScrollState(searchHits.getScrollId());
            private volatile boolean isClosed = false;

            public void close() {
                if (!this.isClosed) {
                    clearScrollConsumer.accept(this.scrollState.getScrollIds());
                    this.isClosed = true;
                }
            }

            @Override
            @Nullable
            public Aggregations getAggregations() {
                return aggregations;
            }

            @Override
            public float getMaxScore() {
                return maxScore;
            }

            @Override
            public long getTotalHits() {
                return totalHits;
            }

            @Override
            public TotalHitsRelation getTotalHitsRelation() {
                return totalHitsRelation;
            }

            public boolean hasNext() {
                boolean hasNext = false;
                if (!this.isClosed && this.continueScroll && (maxCount <= 0 || this.currentCount.get() < maxCount)) {
                    if (!this.currentScrollHits.hasNext()) {
                        SearchScrollHits nextPage = (SearchScrollHits)continueScrollFunction.apply(this.scrollState.getScrollId());
                        this.currentScrollHits = nextPage.iterator();
                        this.scrollState.updateScrollId(nextPage.getScrollId());
                        this.continueScroll = this.currentScrollHits.hasNext();
                    }
                    hasNext = this.currentScrollHits.hasNext();
                }
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            public SearchHit<T> next() {
                if (this.hasNext()) {
                    this.currentCount.incrementAndGet();
                    return this.currentScrollHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private StreamQueries() {
    }
}

