/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query.highlight;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightParameters;
import org.springframework.util.Assert;

public class Highlight {
    private final HighlightParameters parameters;
    private final List<HighlightField> fields;

    public Highlight(HighlightParameters parameters, List<HighlightField> fields) {
        Assert.notNull((Object)parameters, (String)"parameters must not be null");
        Assert.notNull(fields, (String)"fields must not be null");
        this.parameters = parameters;
        this.fields = fields;
    }

    public HighlightParameters getParameters() {
        return this.parameters;
    }

    public List<HighlightField> getFields() {
        return this.fields;
    }

    public static Highlight of(org.springframework.data.elasticsearch.annotations.Highlight highlight) {
        Assert.notNull((Object)highlight, (String)"highlight must not be null");
        org.springframework.data.elasticsearch.annotations.HighlightParameters parameters = highlight.parameters();
        HighlightParameters highlightParameters = ((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)HighlightParameters.builder().withBoundaryChars(parameters.boundaryChars())).withBoundaryMaxScan(parameters.boundaryMaxScan())).withBoundaryScanner(parameters.boundaryScanner())).withBoundaryScannerLocale(parameters.boundaryScannerLocale())).withEncoder(parameters.encoder()).withForceSource(parameters.forceSource())).withFragmenter(parameters.fragmenter())).withFragmentSize(parameters.fragmentSize())).withNoMatchSize(parameters.noMatchSize())).withNumberOfFragments(parameters.numberOfFragments())).withOrder(parameters.order())).withPhraseLimit(parameters.phraseLimit())).withPreTags(parameters.preTags())).withPostTags(parameters.postTags())).withRequireFieldMatch(parameters.requireFieldMatch())).withTagsSchema(parameters.tagsSchema()).withType(parameters.type())).build();
        List<HighlightField> highlightFields = Arrays.stream(highlight.fields()).map(HighlightField::of).collect(Collectors.toList());
        return new Highlight(highlightParameters, highlightFields);
    }
}

