/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;

class MapEntityRowMapper<T>
implements RowMapper<Map.Entry<Object, T>> {
    private final PersistentPropertyPathExtension path;
    private final JdbcConverter converter;
    private final Identifier identifier;
    private final SqlIdentifier keyColumn;
    private final IdentifierProcessing identifierProcessing;

    @NonNull
    public Map.Entry<Object, T> mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object key = rs.getObject(this.keyColumn.getReference(this.identifierProcessing));
        return new AbstractMap.SimpleEntry<Object, T>(key, this.mapEntity(rs, key));
    }

    private T mapEntity(ResultSet resultSet, Object key) {
        return this.converter.mapRow(this.path, resultSet, this.identifier, key);
    }

    public MapEntityRowMapper(PersistentPropertyPathExtension path, JdbcConverter converter, Identifier identifier, SqlIdentifier keyColumn, IdentifierProcessing identifierProcessing) {
        this.path = path;
        this.converter = converter;
        this.identifier = identifier;
        this.keyColumn = keyColumn;
        this.identifierProcessing = identifierProcessing;
    }
}

