/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Constructor;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.ConvertingRowMapper;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.JdbcValueBindUtil;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;
import org.springframework.data.util.Lazy;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class StringBasedJdbcQuery
extends AbstractJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or use the javac flag -parameters";
    private static final String LOCKING_IS_NOT_SUPPORTED = "Currently, @Lock is supported only on derived queries. In other words, for queries created with @Query, the locking condition specified with @Lock does nothing. Offending method: ";
    private final JdbcConverter converter;
    private final RowMapperFactory rowMapperFactory;
    private final ValueExpressionQueryRewriter.ParsedQuery parsedQuery;
    private final String query;
    private final CachedRowMapperFactory cachedRowMapperFactory;
    private final CachedResultSetExtractorFactory cachedResultSetExtractorFactory;
    private final ValueExpressionDelegate delegate;

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, RowMapperFactory rowMapperFactory, JdbcConverter converter, ValueExpressionDelegate delegate) {
        this(queryMethod.getRequiredQuery(), queryMethod, operations, rowMapperFactory, converter, delegate);
    }

    public StringBasedJdbcQuery(String query, JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, RowMapperFactory rowMapperFactory, JdbcConverter converter, ValueExpressionDelegate delegate) {
        super(queryMethod, operations);
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        this.converter = converter;
        this.rowMapperFactory = rowMapperFactory;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries; Offending method: " + String.valueOf((Object)queryMethod));
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries; Offending method: " + String.valueOf((Object)queryMethod));
        }
        if (queryMethod.getParameters().hasLimitParameter()) {
            throw new UnsupportedOperationException("Queries with Limit are not supported using string-based queries; Offending method: " + String.valueOf((Object)queryMethod));
        }
        this.cachedRowMapperFactory = new CachedRowMapperFactory(() -> rowMapperFactory.create(queryMethod.getResultProcessor().getReturnedType().getReturnedType()));
        this.cachedResultSetExtractorFactory = new CachedResultSetExtractorFactory(this.cachedRowMapperFactory::getRowMapper);
        ValueExpressionQueryRewriter.EvaluatingValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionDelegate)delegate, (counter, expression) -> String.format("__$synthetic$__%d", counter + 1), String::concat);
        this.query = query;
        if (queryMethod.hasLockMode()) {
            throw new UnsupportedOperationException(LOCKING_IS_NOT_SUPPORTED + String.valueOf((Object)queryMethod));
        }
        this.parsedQuery = rewriter.parse(this.query);
        this.delegate = delegate;
    }

    public StringBasedJdbcQuery(String query, JdbcQueryMethod queryMethod, JdbcAggregateOperations operations, RowMapperFactory rowMapperFactory, ValueExpressionDelegate delegate) {
        this(query, queryMethod, operations.getDataAccessStrategy().getJdbcOperations(), rowMapperFactory, operations.getConverter(), delegate);
    }

    public @Nullable Object execute(Object[] objects) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), objects);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        JdbcQueryExecution<?> queryExecution = this.createJdbcQueryExecution((RelationalParameterAccessor)accessor, processor);
        MapSqlParameterSource parameterMap = this.bindParameters((RelationalParameterAccessor)accessor);
        return queryExecution.execute(this.evaluateExpressions(objects, accessor.getBindableParameters(), parameterMap), (SqlParameterSource)parameterMap);
    }

    private String evaluateExpressions(Object[] objects, Parameters<?, ?> bindableParameters, MapSqlParameterSource parameterMap) {
        if (this.parsedQuery.hasParameterBindings()) {
            ValueEvaluationContext evaluationContext = this.delegate.createValueContextProvider(bindableParameters).getEvaluationContext((Object)objects);
            this.parsedQuery.getParameterMap().forEach((paramName, valueExpression) -> StringBasedJdbcQuery.addEvaluatedParameterToParameterSource(parameterMap, paramName, valueExpression, evaluationContext));
            return this.parsedQuery.getQueryString();
        }
        return this.query;
    }

    private static void addEvaluatedParameterToParameterSource(MapSqlParameterSource parameterMap, String paramName, ValueExpression valueExpression, ValueEvaluationContext evaluationContext) {
        Object evaluatedValue = valueExpression.evaluate(evaluationContext);
        Class valueType = valueExpression.getValueType(evaluationContext);
        SQLType sqlType = valueType == null ? (evaluatedValue != null ? StringBasedJdbcQuery.getSqlType(evaluatedValue.getClass()) : null) : StringBasedJdbcQuery.getSqlType(valueType);
        if (sqlType != null) {
            parameterMap.addValue(paramName, evaluatedValue, sqlType.getVendorTypeNumber().intValue());
        } else {
            parameterMap.addValue(paramName, evaluatedValue);
        }
    }

    private static SQLType getSqlType(Class<?> valueType) {
        return JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(valueType));
    }

    private JdbcQueryExecution<?> createJdbcQueryExecution(RelationalParameterAccessor accessor, ResultProcessor processor) {
        if (this.getQueryMethod().isModifyingQuery()) {
            return this.createModifyingQueryExecutor();
        }
        Supplier<RowMapper<?>> rowMapper = () -> this.determineRowMapper(processor, accessor.findDynamicProjection() != null);
        ResultSetExtractor<Object> resultSetExtractor = this.determineResultSetExtractor(rowMapper);
        return this.createReadingQueryExecution(resultSetExtractor, rowMapper);
    }

    private MapSqlParameterSource bindParameters(RelationalParameterAccessor accessor) {
        Parameters bindableParameters = accessor.getBindableParameters();
        MapSqlParameterSource parameters = new MapSqlParameterSource(new LinkedHashMap(bindableParameters.getNumberOfParameters(), 1.0f));
        for (Parameter bindableParameter : bindableParameters) {
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            JdbcParameters.JdbcParameter parameter = this.getQueryMethod().getParameters().getParameter(bindableParameter.getIndex());
            JdbcValue jdbcValue = JdbcValueBindUtil.getBindValue(this.converter, value, parameter);
            SQLType jdbcType = jdbcValue.getJdbcType();
            if (jdbcType == JDBCType.OTHER) {
                parameters.addValue(parameterName, jdbcValue.getValue());
                continue;
            }
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
        return parameters;
    }

    RowMapper<Object> determineRowMapper(ResultProcessor resultProcessor, boolean hasDynamicProjection) {
        if (this.cachedRowMapperFactory.isConfiguredRowMapper()) {
            return this.cachedRowMapperFactory.getRowMapper();
        }
        if (hasDynamicProjection) {
            RowMapper<Object> rowMapperToUse = this.rowMapperFactory.create(resultProcessor.getReturnedType().getDomainType());
            JdbcQueryExecution.ResultProcessingConverter converter = new JdbcQueryExecution.ResultProcessingConverter(resultProcessor, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.converter.getMappingContext(), this.converter.getEntityInstantiators());
            return new ConvertingRowMapper(rowMapperToUse, converter);
        }
        return this.cachedRowMapperFactory.getRowMapper();
    }

    @Nullable ResultSetExtractor<Object> determineResultSetExtractor(Supplier<RowMapper<?>> rowMapper) {
        if (this.cachedResultSetExtractorFactory.isConfiguredResultSetExtractor()) {
            if (this.cachedResultSetExtractorFactory.requiresRowMapper() && !this.cachedRowMapperFactory.isConfiguredRowMapper()) {
                return this.cachedResultSetExtractorFactory.getResultSetExtractor(rowMapper);
            }
            return this.cachedResultSetExtractorFactory.getResultSetExtractor();
        }
        return null;
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }

    @Deprecated(since="3.4")
    public void setBeanFactory(BeanFactory beanFactory) {
    }

    static <T> @Nullable Constructor<T> findPrimaryConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findPrimaryConstructor(clazz);
        }
        catch (LinkageError err) {
            throw new BeanInstantiationException(clazz, "Unresolvable class definition", (Throwable)err);
        }
    }

    class CachedRowMapperFactory {
        private final Lazy<RowMapper<Object>> cachedRowMapper;
        private final boolean configuredRowMapper;
        private final @Nullable Constructor<?> constructor;

        public CachedRowMapperFactory(Supplier<RowMapper<Object>> defaultMapper) {
            String rowMapperRef = StringBasedJdbcQuery.this.getQueryMethod().getRowMapperRef();
            Class<? extends RowMapper> rowMapperClass = StringBasedJdbcQuery.this.getQueryMethod().getRowMapperClass();
            if (!ObjectUtils.isEmpty((Object)rowMapperRef) && !StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
                throw new IllegalArgumentException("Invalid RowMapper configuration. Configure either one but not both via @Query(rowMapperRef = \u2026, rowMapperClass = \u2026) for query method " + String.valueOf((Object)StringBasedJdbcQuery.this.getQueryMethod()));
            }
            this.configuredRowMapper = !ObjectUtils.isEmpty((Object)rowMapperRef) || !StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class);
            this.constructor = rowMapperClass != null ? StringBasedJdbcQuery.findPrimaryConstructor(rowMapperClass) : null;
            this.cachedRowMapper = Lazy.of(() -> {
                if (!ObjectUtils.isEmpty((Object)rowMapperRef)) {
                    return this$0.rowMapperFactory.getRowMapper(rowMapperRef);
                }
                if (StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
                    return (RowMapper)defaultMapper.get();
                }
                Assert.state((this.constructor != null ? 1 : 0) != 0, (String)"Constructor must not be null");
                return (RowMapper)BeanUtils.instantiateClass(this.constructor, (Object[])new Object[0]);
            });
        }

        public boolean isConfiguredRowMapper() {
            return this.configuredRowMapper;
        }

        public RowMapper<Object> getRowMapper() {
            return (RowMapper)this.cachedRowMapper.get();
        }
    }

    class CachedResultSetExtractorFactory {
        private final Lazy<ResultSetExtractor<Object>> cachedResultSetExtractor;
        private final boolean configuredResultSetExtractor;
        private final @Nullable Constructor<? extends ResultSetExtractor> rowMapperConstructor;
        private final @Nullable Constructor<? extends ResultSetExtractor> constructor;
        private final Function<Supplier<RowMapper<?>>, ResultSetExtractor<Object>> resultSetExtractorFactory;

        public CachedResultSetExtractorFactory(Supplier<RowMapper<?>> resultSetExtractor) {
            String resultSetExtractorRef = StringBasedJdbcQuery.this.getQueryMethod().getResultSetExtractorRef();
            Class<? extends ResultSetExtractor> resultSetExtractorClass = StringBasedJdbcQuery.this.getQueryMethod().getResultSetExtractorClass();
            if (!ObjectUtils.isEmpty((Object)resultSetExtractorRef) && !StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
                throw new IllegalArgumentException("Invalid ResultSetExtractor configuration. Configure either one but not both via @Query(resultSetExtractorRef = \u2026, resultSetExtractorClass = \u2026) for query method " + String.valueOf((Object)StringBasedJdbcQuery.this.getQueryMethod()));
            }
            this.configuredResultSetExtractor = !ObjectUtils.isEmpty((Object)resultSetExtractorRef) || !StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class);
            this.rowMapperConstructor = resultSetExtractorClass != null ? ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class}) : null;
            this.constructor = resultSetExtractorClass != null ? StringBasedJdbcQuery.findPrimaryConstructor(resultSetExtractorClass) : null;
            this.resultSetExtractorFactory = rowMapper -> {
                if (!ObjectUtils.isEmpty((Object)resultSetExtractorRef)) {
                    return this$0.rowMapperFactory.getResultSetExtractor(resultSetExtractorRef);
                }
                if (StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
                    throw new UnsupportedOperationException("This should not happen");
                }
                if (this.rowMapperConstructor != null) {
                    return (ResultSetExtractor)BeanUtils.instantiateClass(this.rowMapperConstructor, (Object[])new Object[]{rowMapper.get()});
                }
                Assert.state((this.constructor != null ? 1 : 0) != 0, (String)"Constructor must not be null");
                return (ResultSetExtractor)BeanUtils.instantiateClass(this.constructor, (Object[])new Object[0]);
            };
            this.cachedResultSetExtractor = Lazy.of(() -> this.resultSetExtractorFactory.apply(resultSetExtractor));
        }

        public boolean isConfiguredResultSetExtractor() {
            return this.configuredResultSetExtractor;
        }

        public ResultSetExtractor<Object> getResultSetExtractor() {
            return (ResultSetExtractor)this.cachedResultSetExtractor.get();
        }

        public ResultSetExtractor<Object> getResultSetExtractor(Supplier<RowMapper<?>> rowMapperSupplier) {
            return this.resultSetExtractorFactory.apply(rowMapperSupplier);
        }

        public boolean requiresRowMapper() {
            return this.rowMapperConstructor != null;
        }
    }
}

