/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import java.util.Iterator;
import javax.persistence.Parameter;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.util.Assert;

class CriteriaQueryParameterBinder
extends ParameterBinder {
    private final Iterator<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

    CriteriaQueryParameterBinder(JpaParameters parameters, Object[] values, Iterable<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
        super(parameters, values);
        Assert.notNull(expressions);
        this.expressions = expressions.iterator();
    }

    @Override
    protected void bind(Query query, JpaParameters.JpaParameter parameter, Object value, int position) {
        ParameterMetadataProvider.ParameterMetadata<?> metadata = this.expressions.next();
        if (metadata.isIsNullParameter()) {
            return;
        }
        if (parameter.isTemporalParameter()) {
            query.setParameter((Parameter)metadata.getExpression(), (Date)metadata.prepare(value), parameter.getTemporalType());
        } else {
            query.setParameter(metadata.getExpression(), metadata.prepare(value));
        }
    }
}

