/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.MethodReference;

public class MethodReferenceNode
extends ExpressionNode {
    private static final Map<String, String> FUNCTIONS;

    MethodReferenceNode(MethodReference reference, ExpressionState state) {
        super((SpelNode)reference, state);
    }

    public String getMethodName() {
        String name = this.getName();
        String methodName = name.substring(0, name.indexOf(40));
        return FUNCTIONS.get(methodName);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("concat", "$concat");
        map.put("strcasecmp", "$strcasecmp");
        map.put("substr", "$substr");
        map.put("toLower", "$toLower");
        map.put("toUpper", "$toUpper");
        map.put("dayOfYear", "$dayOfYear");
        map.put("dayOfMonth", "$dayOfMonth");
        map.put("dayOfWeek", "$dayOfWeek");
        map.put("year", "$year");
        map.put("month", "$month");
        map.put("week", "$week");
        map.put("hour", "$hour");
        map.put("minute", "$minute");
        map.put("second", "$second");
        map.put("millisecond", "$millisecond");
        FUNCTIONS = Collections.unmodifiableMap(map);
    }
}

