/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.Date;
import java.util.Map;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.lang.Nullable;

public class BsonUtils {
    @Nullable
    public static <T> T get(Bson bson, String key) {
        return (T)BsonUtils.asMap(bson).get(key);
    }

    public static Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof BasicDBObject) {
            return (BasicDBObject)bson;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot read values from " + bson.getClass());
    }

    public static void addToMap(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).put(key, value);
            return;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot add value to " + bson.getClass());
    }

    public static Object toJavaType(BsonValue value) {
        switch (value.getBsonType()) {
            case INT32: {
                return value.asInt32().getValue();
            }
            case INT64: {
                return value.asInt64().getValue();
            }
            case STRING: {
                return value.asString().getValue();
            }
            case DECIMAL128: {
                return value.asDecimal128().doubleValue();
            }
            case DOUBLE: {
                return value.asDouble().getValue();
            }
            case BOOLEAN: {
                return value.asBoolean().getValue();
            }
            case OBJECT_ID: {
                return value.asObjectId().getValue();
            }
            case DB_POINTER: {
                return new DBRef(value.asDBPointer().getNamespace(), (Object)value.asDBPointer().getId());
            }
            case BINARY: {
                return value.asBinary().getData();
            }
            case DATE_TIME: {
                return new Date(value.asDateTime().getValue());
            }
            case SYMBOL: {
                return value.asSymbol().getSymbol();
            }
            case ARRAY: {
                return value.asArray().toArray();
            }
            case DOCUMENT: {
                return Document.parse((String)value.asDocument().toJson());
            }
        }
        return value;
    }
}

