/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.util.Assert;

public class ValidatingMongoEventListener
extends AbstractMongoEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingMongoEventListener.class);
    private final Validator validator;

    public ValidatingMongoEventListener(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator must not be null!");
        this.validator = validator;
    }

    @Override
    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        LOG.debug("Validating object: {}", event.getSource());
        Set violations = this.validator.validate(event.getSource(), new Class[0]);
        if (!violations.isEmpty()) {
            LOG.info("During object: {} validation violations found: {}", event.getSource(), (Object)violations);
            throw new ConstraintViolationException(violations);
        }
    }
}

