/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoOperations operations;
    private final ExecutableFindOperation.ExecutableFind<?> executableFind;
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)operations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        this.method = method;
        this.operations = operations;
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.executableFind = operations.query(type);
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        ConvertingParameterAccessor accessor = new ConvertingParameterAccessor(this.operations.getConverter(), new MongoParametersParameterAccessor(this.method, parameters));
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        return processor.processResult(this.doExecute(this.method, processor, accessor, typeToRead));
    }

    protected Object doExecute(MongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        this.applyQueryMetaAttributesWhenPresent(query);
        query = this.applyAnnotatedDefaultSortIfPresent(query);
        query = this.applyAnnotatedCollationIfPresent(query, accessor);
        ExecutableFindOperation.ExecutableFind<?> find = typeToRead == null ? this.executableFind : this.executableFind.as(typeToRead);
        return this.getExecution(accessor, find).execute(query);
    }

    private MongoQueryExecution getExecution(ConvertingParameterAccessor accessor, ExecutableFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new MongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery() && this.method.isPageQuery()) {
            return new MongoQueryExecution.PagingGeoNearExecution(operation, this.method, accessor, this);
        }
        if (this.method.isGeoNearQuery()) {
            return new MongoQueryExecution.GeoNearExecution(operation, this.method, accessor);
        }
        if (this.method.isSliceQuery()) {
            return new MongoQueryExecution.SlicedExecution(operation, accessor.getPageable());
        }
        if (this.method.isStreamQuery()) {
            return q -> operation.matching(q).stream();
        }
        if (this.method.isCollectionQuery()) {
            return q -> operation.matching(q.with(accessor.getPageable()).with(accessor.getSort())).all();
        }
        if (this.method.isPageQuery()) {
            return new MongoQueryExecution.PagedExecution(operation, accessor.getPageable());
        }
        if (this.isCountQuery()) {
            return q -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return q -> operation.matching(q).exists();
        }
        return q -> {
            ExecutableFindOperation.TerminatingFind find = operation.matching(q);
            return this.isLimiting() ? find.firstValue() : find.oneValue();
        };
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    Query applyAnnotatedDefaultSortIfPresent(Query query) {
        if (!this.method.hasAnnotatedSort()) {
            return query;
        }
        return QueryUtils.decorateSort(query, Document.parse((String)this.method.getAnnotatedSort()));
    }

    Query applyAnnotatedCollationIfPresent(Query query, ConvertingParameterAccessor accessor) {
        return QueryUtils.applyCollation(query, this.method.hasAnnotatedCollation() ? this.method.getAnnotatedCollation() : null, accessor, this.getQueryMethod().getParameters(), this.expressionParser, this.evaluationContextProvider);
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isLimiting();
}

